/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.MaricultureRegistry;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.lib.EnchantIds;
import mariculture.core.lib.Extra;
import mariculture.core.lib.ItemIds;
import mariculture.core.lib.Modules;
import mariculture.magic.EnchantUpdateTicker;
import mariculture.magic.ItemMagicMirror;
import mariculture.magic.ItemMirror;
import mariculture.magic.ItemMobMagnet;
import mariculture.magic.JewelryHandler;
import mariculture.magic.MagicEventHandler;
import mariculture.magic.MirrorHandler;
import mariculture.magic.enchantments.EnchantmentBlink;
import mariculture.magic.enchantments.EnchantmentClock;
import mariculture.magic.enchantments.EnchantmentFallDamage;
import mariculture.magic.enchantments.EnchantmentFire;
import mariculture.magic.enchantments.EnchantmentFlight;
import mariculture.magic.enchantments.EnchantmentGlide;
import mariculture.magic.enchantments.EnchantmentHealth;
import mariculture.magic.enchantments.EnchantmentJump;
import mariculture.magic.enchantments.EnchantmentLuck;
import mariculture.magic.enchantments.EnchantmentNeverHungry;
import mariculture.magic.enchantments.EnchantmentOneRing;
import mariculture.magic.enchantments.EnchantmentPoison;
import mariculture.magic.enchantments.EnchantmentPunch;
import mariculture.magic.enchantments.EnchantmentRestore;
import mariculture.magic.enchantments.EnchantmentResurrection;
import mariculture.magic.enchantments.EnchantmentSpeed;
import mariculture.magic.enchantments.EnchantmentSpider;
import mariculture.magic.enchantments.EnchantmentStepUp;
import mariculture.magic.jewelry.ItemBracelet;
import mariculture.magic.jewelry.ItemJewelry;
import mariculture.magic.jewelry.ItemNecklace;
import mariculture.magic.jewelry.ItemRing;
import mariculture.magic.jewelry.parts.JewelryPart;
import mariculture.magic.jewelry.parts.PartDiamond;
import mariculture.magic.jewelry.parts.PartGold;
import mariculture.magic.jewelry.parts.PartGoldString;
import mariculture.magic.jewelry.parts.PartGoldThread;
import mariculture.magic.jewelry.parts.PartIron;
import mariculture.magic.jewelry.parts.PartOneRing;
import mariculture.magic.jewelry.parts.PartPearlBlack;
import mariculture.magic.jewelry.parts.PartPearlBlue;
import mariculture.magic.jewelry.parts.PartPearlBrown;
import mariculture.magic.jewelry.parts.PartPearlGold;
import mariculture.magic.jewelry.parts.PartPearlGreen;
import mariculture.magic.jewelry.parts.PartPearlOrange;
import mariculture.magic.jewelry.parts.PartPearlPink;
import mariculture.magic.jewelry.parts.PartPearlPurple;
import mariculture.magic.jewelry.parts.PartPearlRed;
import mariculture.magic.jewelry.parts.PartPearlSilver;
import mariculture.magic.jewelry.parts.PartPearlWhite;
import mariculture.magic.jewelry.parts.PartPearlYellow;
import mariculture.magic.jewelry.parts.PartString;
import mariculture.magic.jewelry.parts.PartWool;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;

public class Magic
extends Modules.RegistrationModule {
    public static Enchantment spider;
    public static Enchantment blink;
    public static Enchantment clock;
    public static Enchantment fall;
    public static Enchantment fire;
    public static Enchantment flight;
    public static Enchantment glide;
    public static Enchantment health;
    public static Enchantment jump;
    public static Enchantment hungry;
    public static Enchantment oneRing;
    public static Enchantment poison;
    public static Enchantment punch;
    public static Enchantment repair;
    public static Enchantment resurrection;
    public static Enchantment speed;
    public static Enchantment stepUp;
    public static Enchantment luck;
    public static Item basicMirror;
    public static Item magicMirror;
    public static Item celestialMirror;
    public static Item ring;
    public static Item bracelet;
    public static Item necklace;
    public static Item magnet;

    @Override
    public void registerHandlers() {
        MaricultureHandlers.mirror = new MirrorHandler();
        MinecraftForge.EVENT_BUS.register((Object)new MagicEventHandler());
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new EnchantUpdateTicker(), (Side)Side.SERVER);
        TickRegistry.registerScheduledTickHandler((IScheduledTickHandler)new EnchantUpdateTicker(), (Side)Side.CLIENT);
    }

    @Override
    public void registerBlocks() {
    }

    @Override
    public void registerItems() {
        basicMirror = new ItemMirror(ItemIds.basicMirror, "mirror").func_77655_b("mirror.basic");
        magicMirror = new ItemMagicMirror(ItemIds.magicMirror, 1, 30, "magicMirror", 15, 1000).func_77655_b("mirror.magic");
        celestialMirror = new ItemMagicMirror(ItemIds.celestialMirror, 31, 60, "celestialMirror", 20, 10000).func_77655_b("mirror.celestial");
        ring = new ItemRing(ItemIds.ring).func_77655_b("ring");
        bracelet = new ItemBracelet(ItemIds.bracelet).func_77655_b("bracelet");
        necklace = new ItemNecklace(ItemIds.necklace).func_77655_b("necklace");
        magnet = new ItemMobMagnet(ItemIds.magnet, 100).func_77655_b("mobMagnet");
        RegistryHelper.register(new Object[]{basicMirror, magicMirror, celestialMirror, ring, bracelet, necklace, magnet});
    }

    @Override
    public void registerOther() {
        this.registerJewelry();
        this.registerEnchants();
        MaricultureTab.tabJewelry.icon = new ItemStack(basicMirror);
    }

    private void registerJewelry() {
        new PartPearlBlack();
        new PartPearlBlue();
        new PartPearlBrown();
        new PartPearlGold();
        new PartPearlGreen();
        new PartPearlOrange();
        new PartPearlPink();
        new PartPearlPurple();
        new PartPearlRed();
        new PartPearlSilver();
        new PartPearlWhite();
        new PartPearlYellow();
        new PartDiamond();
        new PartGold();
        new PartIron();
        new PartGoldString();
        new PartString();
        new PartOneRing();
        new PartGoldThread();
        new PartWool();
    }

    private void registerEnchants() {
        if (EnchantIds.spider > 0) {
            spider = new EnchantmentSpider(EnchantIds.spider, 4, EnumEnchantmentType.all);
        }
        if (EnchantIds.blink > 0) {
            blink = new EnchantmentBlink(EnchantIds.blink, 1, EnumEnchantmentType.all);
        }
        if (EnchantIds.clock > 0) {
            clock = new EnchantmentClock(EnchantIds.clock, 2, EnumEnchantmentType.all);
        }
        if (EnchantIds.fall > 0) {
            fall = new EnchantmentFallDamage(EnchantIds.fall, 10, EnumEnchantmentType.all);
        }
        if (EnchantIds.fire > 0) {
            fire = new EnchantmentFire(EnchantIds.fire, 10, EnumEnchantmentType.all);
        }
        if (EnchantIds.flight > 0) {
            flight = new EnchantmentFlight(EnchantIds.flight, 1, EnumEnchantmentType.all);
        }
        if (EnchantIds.glide > 0) {
            glide = new EnchantmentGlide(EnchantIds.glide, 8, EnumEnchantmentType.all);
        }
        if (EnchantIds.health > 0) {
            health = new EnchantmentHealth(EnchantIds.health, 8, EnumEnchantmentType.all);
        }
        if (EnchantIds.jump > 0) {
            jump = new EnchantmentJump(EnchantIds.jump, 12, EnumEnchantmentType.all);
        }
        if (EnchantIds.hungry > 0) {
            hungry = new EnchantmentNeverHungry(EnchantIds.hungry, 8, EnumEnchantmentType.all);
        }
        if (EnchantIds.oneRing > 0) {
            oneRing = new EnchantmentOneRing(EnchantIds.oneRing, 0, EnumEnchantmentType.all);
        }
        if (EnchantIds.poison > 0) {
            poison = new EnchantmentPoison(EnchantIds.poison, 11, EnumEnchantmentType.all);
        }
        if (EnchantIds.punch > 0) {
            punch = new EnchantmentPunch(EnchantIds.punch, 12, EnumEnchantmentType.all);
        }
        if (EnchantIds.repair > 0) {
            repair = new EnchantmentRestore(EnchantIds.repair, 6, EnumEnchantmentType.all);
        }
        if (EnchantIds.resurrection > 0) {
            resurrection = new EnchantmentResurrection(EnchantIds.resurrection, 1, EnumEnchantmentType.all);
        }
        if (EnchantIds.speed > 0) {
            speed = new EnchantmentSpeed(EnchantIds.speed, 10, EnumEnchantmentType.all);
        }
        if (EnchantIds.stepUp > 0) {
            stepUp = new EnchantmentStepUp(EnchantIds.stepUp, 9, EnumEnchantmentType.all);
        }
        if (EnchantIds.luck > 0) {
            luck = new EnchantmentLuck(EnchantIds.luck, 5, EnumEnchantmentType.all);
        }
    }

    @Override
    public void registerRecipes() {
        RecipeHelper.addShapedRecipe(new ItemStack(basicMirror), new Object[]{" AA", "APA", "SA ", Character.valueOf('A'), "ingotAluminum", Character.valueOf('P'), Block.field_72003_bq, Character.valueOf('S'), "ingotIron"});
        RecipeHelper.addShapedRecipe(new ItemStack(magicMirror), new Object[]{"PMP", "BEB", "PBP", Character.valueOf('B'), new ItemStack(Core.machines, 1, 6), Character.valueOf('M'), basicMirror, Character.valueOf('E'), Block.field_72096_bE, Character.valueOf('P'), new ItemStack(Core.pearls, 1, Short.MAX_VALUE)});
        ItemStack drop = Modules.isActive(Modules.fishery) ? new ItemStack(Core.materials, 1, 24) : new ItemStack(Item.field_77732_bp);
        RecipeHelper.addShapedRecipe(new ItemStack(celestialMirror), new Object[]{"TST", "BMB", "GBG", Character.valueOf('B'), new ItemStack(Core.machines, 1, 6), Character.valueOf('M'), magicMirror, Character.valueOf('S'), Item.field_82792_bS, Character.valueOf('T'), drop, Character.valueOf('G'), new ItemStack(Core.crafting, 1, 1)});
        this.addJewelry(Magic.ring.field_77779_bT, 0, "jewel", "material");
        this.addJewelry(Magic.bracelet.field_77779_bT, 1, "material", "string");
        this.addJewelry(Magic.necklace.field_77779_bT, 2, "material", "string");
        this.addDungeonChestLoot();
        if (Extra.MOB_MAGNET) {
            RecipeHelper.addShapedRecipe(new ItemStack(magnet), new Object[]{"III", "I I", "M M", Character.valueOf('I'), "ingotIron", Character.valueOf('M'), Item.field_77730_bn});
        }
    }

    private void addJewelry(int id, int type, String partOne, String partTwo) {
        ItemStack output;
        int j;
        int i;
        for (i = 0; i < JewelryPart.materialList.size(); ++i) {
            for (j = 0; j < JewelryPart.materialList.size(); ++j) {
                int Multiply1;
                if (!JewelryPart.materialList.get(i).isValid(type) || !JewelryPart.materialList.get(j).isValid(type) || !JewelryPart.materialList.get(i).getPartType(type).equals(partOne) || !JewelryPart.materialList.get(j).getPartType(type).equals(partTwo)) continue;
                output = ItemJewelry.buildJewelry(id, i, j);
                output = JewelryPart.materialList.get(i).addEnchantments(output);
                if (i != j) {
                    output = JewelryPart.materialList.get(j).addEnchantments(output);
                }
                ItemStack input1 = JewelryPart.materialList.get(i).getItemStack();
                ItemStack input2 = JewelryPart.materialList.get(j).getItemStack();
                int n = type == 0 ? 1 : (Multiply1 = type == 1 ? 3 : 7);
                int Multiply2 = type == 0 ? 7 : (type == 1 ? 2 : 1);
                int frame = JewelryPart.materialList.get(i).getHits(type) * Multiply1;
                int other = JewelryPart.materialList.get(j).getHits(type) * Multiply2;
                int hits = frame + other;
                if (input1 == null || input2 == null || output == null || !JewelryPart.materialList.get(i).isEnabled(type) || !JewelryPart.materialList.get(j).isEnabled(type)) continue;
                JewelryHandler.addJewelry(output, input1, input2, type, hits);
            }
        }
        for (i = 0; i < JewelryPart.materialList.size(); ++i) {
            for (j = 0; j < JewelryPart.materialList.size(); ++j) {
                if (!JewelryPart.materialList.get(i).isValid(type) || !JewelryPart.materialList.get(j).isValid(type) || !JewelryPart.materialList.get(i).getPartType(type).equals(partOne) || !JewelryPart.materialList.get(j).getPartType(type).equals(partTwo)) continue;
                output = ItemJewelry.buildJewelry(id, i, j);
                output = JewelryPart.materialList.get(i).addEnchantments(output);
                if (i != j) {
                    output = JewelryPart.materialList.get(j).addEnchantments(output);
                }
                String name = output.func_77977_a().substring(5);
                name = name + "." + JewelryPart.materialList.get(i).getPartName();
                if (!JewelryPart.materialList.get(i).isSingle()) {
                    name = name + "." + JewelryPart.materialList.get(j).getPartName();
                }
                MaricultureRegistry.register(name, output);
            }
        }
    }

    private void addDungeonChestLoot() {
        ItemStack oneRing;
        if (EnchantHelper.exists(Magic.oneRing) && (oneRing = MaricultureRegistry.get("ring.oneRing")) != null) {
            ChestGenHooks.addItem((String)"dungeonChest", (WeightedRandomChestContent)new WeightedRandomChestContent(oneRing, 1, 1, 1));
        }
    }
}

