/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.EnumSet;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.lib.Extra;
import mariculture.core.network.Packet105OneRing;
import mariculture.core.network.Packet111UpdateEnchants;
import mariculture.core.network.Packets;
import mariculture.magic.Magic;
import mariculture.magic.enchantments.EnchantmentFlight;
import mariculture.magic.enchantments.EnchantmentGlide;
import mariculture.magic.enchantments.EnchantmentHealth;
import mariculture.magic.enchantments.EnchantmentJump;
import mariculture.magic.enchantments.EnchantmentNeverHungry;
import mariculture.magic.enchantments.EnchantmentPoison;
import mariculture.magic.enchantments.EnchantmentRestore;
import mariculture.magic.enchantments.EnchantmentSpeed;
import mariculture.magic.enchantments.EnchantmentSpider;
import mariculture.magic.enchantments.EnchantmentStepUp;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;

public class EnchantUpdateTicker
implements IScheduledTickHandler {
    public void tickStart(EnumSet<TickType> type, Object ... tickData) {
        EntityPlayer player = (EntityPlayer)tickData[0];
        if (!player.field_70170_p.field_72995_K) {
            int speed = EnchantHelper.getEnchantStrength(Magic.speed, player);
            int jump = EnchantHelper.getEnchantStrength(Magic.jump, player);
            int glide = EnchantHelper.getEnchantStrength(Magic.glide, player);
            int flight = EnchantHelper.getEnchantStrength(Magic.flight, player);
            int step = EnchantHelper.getEnchantStrength(Magic.stepUp, player);
            boolean spider = EnchantHelper.hasEnchantment(Magic.spider, player);
            EnchantmentSpeed.set(speed);
            EnchantmentJump.set(jump);
            EnchantmentGlide.set(glide);
            EnchantmentFlight.set(flight);
            EnchantmentSpider.set(spider);
            EnchantmentStepUp.set(step, player);
            PacketDispatcher.sendPacketToPlayer((Packet)new Packet111UpdateEnchants(speed, jump, glide, flight, spider, step).build(), (Player)((Player)player));
            Packets.updatePlayer(player, 128, new Packet105OneRing(player.field_70157_k, player.func_82150_aj()).build());
            if (EnchantHelper.hasEnchantment(Magic.hungry, player)) {
                EnchantmentNeverHungry.activate(player);
            }
            if (EnchantHelper.hasEnchantment(Magic.health, player)) {
                EnchantmentHealth.activate(player);
            }
            if (EnchantHelper.getEnchantStrength(Magic.poison, player) > 2) {
                EnchantmentPoison.activate(player);
            }
            if (EnchantHelper.hasEnchantment(Magic.repair, player)) {
                EnchantmentRestore.activate(player);
            }
        } else if (EnchantHelper.exists(Magic.flight)) {
            EnchantmentFlight.activate(player);
        }
    }

    public void tickEnd(EnumSet<TickType> type, Object ... tickData) {
    }

    public EnumSet<TickType> ticks() {
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return "Mariculture - Jewelry Enchant Ticker";
    }

    public int nextTickSpacing() {
        return Extra.JEWELRY_TICK_RATE;
    }
}

