/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishDNABase;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Text;
import mariculture.fishery.Fish;
import mariculture.fishery.FishHelper;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemFishy
extends Item {
    private static Icon egg;

    public ItemFishy(int i) {
        super(i);
        this.field_77777_bU = 1;
        this.func_77627_a(true);
    }

    public boolean func_77623_v() {
        return true;
    }

    public String func_77667_c(ItemStack stack) {
        FishSpecies species = Fishing.fishHelper.getSpecies(stack);
        if (species != null) {
            return this.func_77658_a() + "." + species.getID();
        }
        return "fishy";
    }

    public String func_77628_j(ItemStack stack) {
        if (Fishing.fishHelper.isEgg(stack)) {
            return Text.localize("fish.data.species.egg");
        }
        FishSpecies active = FishSpecies.species.get(Fish.species.getDNA(stack));
        FishSpecies inactive = FishSpecies.species.get(Fish.species.getLowerDNA(stack));
        if (active == null || inactive == null) {
            return Text.translate("anyFish");
        }
        if (active != inactive) {
            return "\u00a7b" + active.getName() + "-" + inactive.getName() + " " + Text.localize("fish.data.hybrid") + this.convertToSymbol(Fish.gender.getDNA(stack));
        }
        return "\u00a7b" + active.getName() + this.convertToSymbol(Fish.gender.getDNA(stack));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        if (Fishing.fishHelper.isEgg(stack)) {
            if (stack.field_77990_d.func_74762_e("currentFertility") > 0) {
                list.add(stack.field_77990_d.func_74762_e("currentFertility") + " " + Text.translate("eggsRemaining"));
            } else {
                list.add(Text.translate("undetermined") + " " + Text.translate("eggsRemaining"));
            }
        } else {
            FishSpecies species = Fishing.fishHelper.getSpecies(stack);
            if (species != null) {
                for (int i = 0; i < FishDNABase.DNAParts.size(); ++i) {
                    FishDNABase.DNAParts.get(i).getInformationDisplay(stack, list);
                }
            }
        }
    }

    public Icon getIcon(ItemStack stack, int pass) {
        if (Fishing.fishHelper.isEgg(stack)) {
            return egg;
        }
        FishSpecies species = Fishing.fishHelper.getSpecies(stack);
        if (species != null) {
            return species.getIcon(Fish.gender.getDNA(stack));
        }
        return Fish.cod.getIcon(0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
            species.getValue().registerIcon(iconRegister);
        }
        egg = iconRegister.func_94245_a("mariculture:fish/egg");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int j, CreativeTabs creative, List list) {
        for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
            FishSpecies fishy = species.getValue();
            ItemStack fish = Fishing.fishHelper.makePureFish(fishy);
            list.add(Fish.gender.addDNA(fish, FishHelper.MALE));
            list.add(Fish.gender.addDNA(fish.func_77946_l(), FishHelper.FEMALE));
        }
    }

    private String convertToSymbol(int gender) {
        return gender == FishHelper.MALE ? "\u2642" : "\u2640";
    }

    public boolean func_77651_p() {
        return true;
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        if (Fishing.fishHelper.isEgg(stack)) {
            return 6000;
        }
        return 15;
    }
}

