/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import java.util.ArrayList;
import mariculture.api.core.Environment;
import mariculture.api.fishery.CachedCoords;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import mariculture.core.util.Rand;
import mariculture.fishery.Fishery;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class FishUndead
extends FishSpecies {
    public FishUndead(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-5, 50};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 15;
    }

    @Override
    public int getFertility() {
        return 350;
    }

    @Override
    public boolean requiresFood() {
        return true;
    }

    @Override
    public int getWaterRequired() {
        return 55;
    }

    @Override
    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return dir == ForgeDirection.UP || dir == ForgeDirection.DOWN ? 1 : 0;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletEarth, 7.5);
        this.addProduct(new ItemStack(Fishery.bait, 1, 2), 15.0);
        this.addProduct(Items.zombie, 1.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.0;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Items.rottenFlesh);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 1;
    }

    @Override
    public void affectWorld(World world, int x, int y, int z, ArrayList<CachedCoords> coords) {
        if (Rand.nextInt(500)) {
            EntityZombie zombie = new EntityZombie(world);
            zombie.func_70107_b((double)x, (double)y, (double)z);
            world.func_72838_d((Entity)zombie);
        }
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            entity.func_70690_d(new PotionEffect(Potion.field_76438_s.field_76415_H, 150, 1, true));
        }
    }

    @Override
    public boolean canWork(int time) {
        return !Environment.Time.isNoon(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Height.isDeep(height) || Environment.Time.isMidnight(time) ? 15.0 : 0.0;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return height < 8 ? 5.0 : 0.0;
    }
}

