/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class FishTang
extends FishSpecies {
    public FishTang(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{24, 29};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 9;
    }

    @Override
    public int getFertility() {
        return 4000;
    }

    @Override
    public int getWaterRequired() {
        return 25;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 6.5);
        this.addProduct(Items.dropletAqua, 4.5);
        this.addProduct(Items.lapis, 2.0);
    }

    @Override
    public double getFishOilVolume() {
        return 0.725;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return Items.lapis;
    }

    @Override
    public int getLiquifiedProductChance() {
        return 8;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76430_j.field_76415_H, 80, 0));
    }

    @Override
    public boolean canWork(int time) {
        return Environment.Time.isDay(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.GOOD;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Height.isShallows(height) ? 25.0 : 0.0;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isDawn(time) ? 5.0 : 0.0;
    }
}

