/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import java.util.Random;
import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class FishStingRay
extends FishSpecies {
    public FishStingRay(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{19, 29};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.BRACKISH, Environment.Salinity.SALINE, Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 25;
    }

    @Override
    public int getFertility() {
        return 1;
    }

    @Override
    public int getWaterRequired() {
        return 20;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletPoison, 5.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.725;
    }

    @Override
    public int getFishMealSize() {
        return 3;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 800, 1));
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            int chance;
            EntityPlayer player = (EntityPlayer)entity;
            Random rand = new Random();
            int difficulty = player.field_70170_p.field_73013_u;
            if (difficulty > 0 && rand.nextInt(chance = 40 - difficulty * 10) == 0) {
                player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, difficulty * 100, 1, true));
            }
        }
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public int getCatchChance() {
        return 35;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isDay(time) ? 50.0 : 25.0;
    }
}

