/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class FishSalmon
extends FishSpecies {
    public FishSalmon(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{0, 23};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH, Environment.Salinity.BRACKISH, Environment.Salinity.SALINE};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 8;
    }

    @Override
    public int getFertility() {
        return 2500;
    }

    @Override
    public int getWaterRequired() {
        return 40;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 5.0);
        this.addProduct(Items.dropletPlant, 5.0);
    }

    @Override
    public double getFishOilVolume() {
        return 4.5;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Item.field_77770_aF);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 5;
    }

    @Override
    public int getFishMealSize() {
        return 5;
    }

    @Override
    public int getFoodStat() {
        return 5;
    }

    @Override
    public float getFoodSaturation() {
        return 0.5f;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public int getCatchChance() {
        return 20;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Height.isHigh(height) && Environment.Time.isNoon(time) ? 5.0 : 0.0;
    }
}

