/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;

public class FishMinnow
extends FishSpecies {
    public FishMinnow(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-1, 45};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 5;
    }

    @Override
    public int getFertility() {
        return 1000;
    }

    @Override
    public int getBaseProductivity() {
        return 2;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 15.0);
    }

    @Override
    public double getFishOilVolume() {
        return 0.24;
    }

    @Override
    public int getFishMealSize() {
        return 1;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public double getCatchChance(int height, int time) {
        if (Environment.Time.isDay(time)) {
            return 33.0;
        }
        return 5.0;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return !Environment.Time.isMidnight(time) && height > 70 ? 75.0 : 20.0;
    }
}

