/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class FishKoi
extends FishSpecies {
    public FishKoi(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{5, 30};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 50;
    }

    @Override
    public int getFertility() {
        return 350;
    }

    @Override
    public int getFoodConsumption() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 300;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getAreaOfEffectBonus(ForgeDirection dir) {
        if (dir == ForgeDirection.UP) return 0;
        if (dir == ForgeDirection.DOWN) return 0;
        return 2;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 5.0);
        this.addProduct(Items.dropletAqua, 3.0);
        this.addProduct(Items.dropletRegen, 4.0);
    }

    @Override
    public double getFishOilVolume() {
        return 5.45;
    }

    @Override
    public int getFishMealSize() {
        return 7;
    }

    @Override
    public int getFoodStat() {
        return 4;
    }

    @Override
    public float getFoodSaturation() {
        return 0.6f;
    }

    @Override
    public int getFoodDuration() {
        return 48;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 100, 2));
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        entity.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 33, 1, true));
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.FLUX;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Time.isDawn(time) ? 10.0 : (Environment.Time.isDusk(time) ? 8.0 : 2.0);
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isDusk(time) && height > 48 && height < 58 ? 5.0 : 0.0;
    }
}

