/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.item.ItemStack;

public class FishHerring
extends FishSpecies {
    public FishHerring(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{10, 18};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 16;
    }

    @Override
    public int getFertility() {
        return 5000;
    }

    @Override
    public int getFoodConsumption() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 60;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 3.0);
        this.addProduct(Items.dropletRegen, 0.5);
        this.addProduct(Items.dropletFrozen, 3.0);
        this.addProduct(Items.redstone, 1.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.05;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Items.redstone);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 5;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public int getCatchChance() {
        return 7;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isDusk(time) && Environment.Height.isShallows(height) ? 5.0 : 0.0;
    }
}

