/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.item.ItemStack;

public class FishGold
extends FishSpecies {
    public FishGold(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-5, 22};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 6;
    }

    @Override
    public int getFertility() {
        return 500;
    }

    @Override
    public int getBaseProductivity() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 25;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 4.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.125;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Items.goldNugget);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 20;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public int getCatchChance() {
        return 15;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isNoon(time) ? 5.0 : 0.0;
    }
}

