/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.lib.Items;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FishGlow
extends FishSpecies {
    public FishGlow(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{35, 100};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isLavaFish() {
        return true;
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 20;
    }

    @Override
    public int getFertility() {
        return 450;
    }

    @Override
    public int getFoodConsumption() {
        return 3;
    }

    @Override
    public int getWaterRequired() {
        return 120;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletNether, 7.5);
        this.addProduct(Items.glowstone, 7.5);
    }

    @Override
    public double getFishOilVolume() {
        return 2.725;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Items.glowstone);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 1;
    }

    @Override
    public int getFishMealSize() {
        return 5;
    }

    @Override
    public int getFoodStat() {
        return 3;
    }

    @Override
    public float getFoodSaturation() {
        return 0.4f;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        SpawnItemHelper.addToPlayerInventory(player, new ItemStack(Items.glowstone));
    }

    @Override
    public int getLightValue() {
        return 15;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.GOOD;
    }

    @Override
    public boolean isWorldCorrect(World world) {
        return world.field_73011_w.field_76575_d;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Height.isHigh(height) ? 50.0 : 25.0;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return height > 110 ? 5.0 : 0.0;
    }
}

