/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class FishDamsel
extends FishSpecies {
    public FishDamsel(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{22, 27};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 5;
    }

    @Override
    public int getFertility() {
        return 500;
    }

    @Override
    public int getBaseProductivity() {
        return 2;
    }

    @Override
    public int getWaterRequired() {
        return 15;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 3.5);
        this.addProduct(Items.dropletRegen, 0.5);
    }

    @Override
    public double getFishOilVolume() {
        return 0.9;
    }

    @Override
    public int getFishMealSize() {
        return 1;
    }

    @Override
    public float getFoodSaturation() {
        return 0.1f;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76428_l.field_76415_H, 100, 0));
    }

    @Override
    public boolean canWork(int time) {
        return !Environment.Time.isMidnight(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Time.isDawn(time) ? 45.0 : (Environment.Time.isNoon(time) ? 25.0 : 0.0);
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isDawn(time) ? 55.0 : (Environment.Time.isNoon(time) ? 85.0 : 0.0);
    }
}

