/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import java.util.ArrayList;
import mariculture.api.core.Environment;
import mariculture.api.fishery.CachedCoords;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import mariculture.core.util.Rand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class FishBoneless
extends FishSpecies {
    public FishBoneless(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-5, 20};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 30;
    }

    @Override
    public int getFertility() {
        return 50;
    }

    @Override
    public int getFoodConsumption() {
        return 0;
    }

    @Override
    public boolean requiresFood() {
        return false;
    }

    @Override
    public int getWaterRequired() {
        return 150;
    }

    @Override
    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return dir == ForgeDirection.UP || dir == ForgeDirection.DOWN ? 1 : 0;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletEarth, 1.0);
        this.addProduct(Items.bonemeal, 5.0);
        this.addProduct(Items.bone, 1.5);
        this.addProduct(Items.skull, 1.0);
        this.addProduct(Items.witherSkull, 0.1);
    }

    @Override
    public double getFishOilVolume() {
        return 0.0;
    }

    @Override
    public int getLiquifiedProductChance() {
        return 1;
    }

    @Override
    public int getFishMealSize() {
        return 0;
    }

    @Override
    public int getFoodStat() {
        return 0;
    }

    @Override
    public void affectWorld(World world, int x, int y, int z, ArrayList<CachedCoords> coords) {
        if (Rand.nextInt(500)) {
            EntitySkeleton skeleton = new EntitySkeleton(world);
            skeleton.func_70107_b((double)x, (double)y, (double)z);
            if (Rand.nextInt(5000)) {
                skeleton.func_82201_a(1);
                skeleton.func_70062_b(0, new ItemStack(Item.field_77711_v));
                skeleton.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
            }
            world.func_72838_d((Entity)skeleton);
        }
    }

    @Override
    public boolean canWork(int time) {
        return Environment.Time.isNoon(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.GOOD;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Height.isCave(height) ? 10.0 : (Environment.Time.isMidnight(time) ? 10.0 : 0.0);
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Height.isDeep(height) ? 5.0 : 0.0;
    }
}

