/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class FishBlaze
extends FishSpecies {
    public FishBlaze(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{50, 100};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.FRESH};
    }

    @Override
    public boolean isLavaFish() {
        return true;
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 15;
    }

    @Override
    public int getFertility() {
        return 350;
    }

    @Override
    public int getWaterRequired() {
        return 125;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletNether, 10.0);
        this.addProduct(Items.blazePowder, 5.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.0;
    }

    @Override
    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Item.field_77731_bo);
    }

    @Override
    public int getLiquifiedProductChance() {
        return 20;
    }

    @Override
    public int getFishMealSize() {
        return 2;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70015_d(7);
    }

    @Override
    public int getLightValue() {
        return 1;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.SUPER;
    }

    @Override
    public boolean isWorldCorrect(World world) {
        return world.field_73011_w.field_76575_d;
    }

    @Override
    public int getCatchChance() {
        return 20;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return height >= 98 && height <= 102 ? 5.0 : 0.0;
    }
}

