/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class FishBlaasop
extends FishSpecies {
    public FishBlaasop(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{-3, 20};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE, Environment.Salinity.BRACKISH};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 12;
    }

    @Override
    public int getFertility() {
        return 150;
    }

    @Override
    public int getWaterRequired() {
        return 40;
    }

    @Override
    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN ? 3 : 0;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 3.0);
        this.addProduct(Items.dropletPoison, 0.5);
        this.addProduct(Items.dropletEarth, 1.0);
    }

    @Override
    public double getFishOilVolume() {
        return 0.45;
    }

    @Override
    public boolean canAlwaysEat() {
        return true;
    }

    @Override
    public void onConsumed(World world, EntityPlayer player) {
        player.func_70690_d(new PotionEffect(Potion.field_76433_i.field_76415_H, 1, 0));
        player.func_70690_d(new PotionEffect(Potion.field_76436_u.field_76415_H, 200, 5));
        player.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 500, 0));
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 150, 1, true));
        entity.func_70690_d(new PotionEffect(Potion.field_82731_v.field_76415_H, 250, 0, true));
    }

    @Override
    public boolean canWork(int time) {
        return !Environment.Time.isNoon(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.OLD;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return height < 32 ? 40.0 : 0.0;
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return 65.0;
    }
}

