/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import mariculture.api.core.Environment;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.lib.Items;
import net.minecraftforge.common.ForgeDirection;

public class FishAngler
extends FishSpecies {
    public FishAngler(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{0, 12};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE};
    }

    @Override
    public boolean isDominant() {
        return true;
    }

    @Override
    public int getLifeSpan() {
        return 20;
    }

    @Override
    public int getFertility() {
        return 5000;
    }

    @Override
    public int getFoodConsumption() {
        return 3;
    }

    @Override
    public int getWaterRequired() {
        return 110;
    }

    @Override
    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return dir == ForgeDirection.DOWN ? 1 : 0;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 3.0);
        this.addProduct(Items.dropletDestroy, 0.5);
        this.addProduct(Items.dropletFlux, 1.5);
    }

    @Override
    public double getFishOilVolume() {
        return 4.555;
    }

    @Override
    public int getFishMealSize() {
        return 4;
    }

    @Override
    public int getFoodStat() {
        return 2;
    }

    @Override
    public float getFoodSaturation() {
        return 0.2f;
    }

    @Override
    public int getLightValue() {
        return 3;
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.SUPER;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Height.isDeep(height) ? 15.0 : (Environment.Height.isCave(height) ? 10.0 : 0.0);
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Height.isDeep(height) ? 4.0 : 0.0;
    }

    @Override
    public boolean hasGenderIcons() {
        return true;
    }
}

