/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.fish;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mariculture.api.core.Environment;
import mariculture.api.fishery.CachedCoords;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.helpers.cofh.InventoryHelper;
import mariculture.core.lib.Items;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class FishAngel
extends FishSpecies {
    public FishAngel(int id) {
        super(id);
    }

    @Override
    public int[] setSuitableTemperature() {
        return new int[]{19, 27};
    }

    @Override
    public Environment.Salinity[] setSuitableSalinity() {
        return new Environment.Salinity[]{Environment.Salinity.SALINE};
    }

    @Override
    public boolean isDominant() {
        return false;
    }

    @Override
    public int getLifeSpan() {
        return 10;
    }

    @Override
    public int getFertility() {
        return 500;
    }

    @Override
    public int getWaterRequired() {
        return 30;
    }

    @Override
    public void addFishProducts() {
        this.addProduct(Items.dropletWater, 1.5);
        this.addProduct(Items.dropletRegen, 2.0);
    }

    @Override
    public double getFishOilVolume() {
        return 1.6;
    }

    @Override
    public ItemStack onRightClick(World world, EntityPlayer player, ItemStack stack, Random rand) {
        if (!world.field_72995_K) {
            List list = world.func_72872_a(EntityItem.class, player.field_70121_D.func_72314_b(64.0, 64.0, 64.0));
            for (Object i : list) {
                ((EntityItem)i).func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
            }
        }
        return stack;
    }

    @Override
    public void affectWorld(World world, int x, int y, int z, ArrayList<CachedCoords> coords) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_72796_p(x, y - 1, z)) instanceof IInventory) {
            List list = world.func_72872_a(EntityItem.class, Block.field_71981_t.func_71872_e(world, x, y - 1, z).func_72314_b(16.0, 16.0, 16.0));
            for (Object i : list) {
                EntityItem item = (EntityItem)i;
                ItemStack stack = item.func_92059_d();
                ItemStack newStack = InventoryHelper.insertItemStackIntoInventory((IInventory)tile, stack, ForgeDirection.DOWN.ordinal());
                if (newStack == null) {
                    item.func_70106_y();
                    continue;
                }
                item.func_92058_a(newStack);
            }
        }
    }

    @Override
    public void affectLiving(EntityLivingBase entity) {
        if (entity.func_110143_aJ() < 1.0f) {
            entity.func_70691_i(1.0f);
        }
    }

    @Override
    public boolean canWork(int time) {
        return !Environment.Time.isMidnight(time);
    }

    @Override
    public RodQuality getRodNeeded() {
        return RodQuality.GOOD;
    }

    @Override
    public double getCatchChance(int height, int time) {
        return Environment.Time.isDawn(time) ? 45.0 : (Environment.Time.isNoon(time) ? 15.0 : 0.0);
    }

    @Override
    public double getCaughtAliveChance(int height, int time) {
        return Environment.Time.isDawn(time) && Environment.Height.isShallows(height) ? 5.0 : 0.0;
    }
}

