/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.blocks;

import java.util.ArrayList;
import java.util.List;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.CachedCoords;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.Core;
import mariculture.core.blocks.base.TileMachineTank;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.lib.Extra;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.lib.Text;
import mariculture.core.util.FluidDictionary;
import mariculture.core.util.IHasNotification;
import mariculture.core.util.Rand;
import mariculture.fishery.Fish;
import mariculture.fishery.FishFoodHandler;
import mariculture.fishery.FishHelper;
import mariculture.fishery.Fishery;
import mariculture.fishery.items.ItemFishy;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class TileFeeder
extends TileMachineTank
implements IHasNotification {
    private boolean swap = false;
    public int tankSize = 0;
    private int foodTick;
    public static final int fluid = 3;
    public static final int male = 5;
    public static final int female = 6;
    public static final int[] out = new int[]{7, 8, 9, 10, 11, 12};
    public ArrayList<CachedCoords> coords = new ArrayList();

    public TileFeeder() {
        this.max = MachineSpeeds.getFeederSpeed();
        this.inventory = new ItemStack[13];
    }

    @Override
    public int getTankCapacity(int storage) {
        return 2 * this.tankSize * (storage + 1);
    }

    public int[] func_94128_d(int var1) {
        return new int[]{5, 6, 3, 7, 8, 9, 10, 11, 12};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 5) {
            return Fishing.fishHelper.isMale(stack);
        }
        if (slot == 6) {
            return Fishing.fishHelper.isFemale(stack);
        }
        if (slot == 3) {
            return FluidHelper.isFluidOrEmpty(stack);
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot > 6;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (slot == 5 && stack != null && stack.func_77973_b() instanceof ItemFishy && Fishing.fishHelper.isMale(stack)) {
            this.updateTankSize();
        }
    }

    @Override
    public void updateMachine() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.onTick(30) || this.field_70331_k.field_73011_w.field_76575_d) {
                this.addFishFood();
            }
            if (this.onTick(30)) {
                this.processContainers();
            }
            if (this.canWork) {
                ++this.foodTick;
                ++this.processed;
                if (this.onTick(Extra.EFFECT_TICK)) {
                    if (this.swap) {
                        this.doEffect(this.inventory[5]);
                        this.swap = false;
                    } else {
                        this.doEffect(this.inventory[6]);
                        this.swap = true;
                    }
                }
                if (this.foodTick % Extra.FISH_FOOD_TICK == 0) {
                    if (this.swap) {
                        this.useFood(this.inventory[5]);
                    } else {
                        this.useFood(this.inventory[6]);
                    }
                }
                if (this.processed >= this.max) {
                    this.processed = 0;
                    if (this.swap) {
                        this.makeProduct(this.inventory[6]);
                    } else {
                        this.makeProduct(this.inventory[5]);
                    }
                    this.damageFish(this.inventory[6], true);
                    this.damageFish(this.inventory[5], true);
                    this.canWork = this.canWork();
                }
            } else {
                this.processed = 0;
            }
        }
    }

    @Override
    public boolean canWork() {
        return this.hasMale() && this.hasFemale() && FeatureRedstone.RedstoneMode.canWork(this, this.mode) && this.outputHasRoom() && this.fishCanLive(5) && this.fishCanLive(6);
    }

    private boolean outputHasRoom() {
        if (this.setting.canEject(FeatureEject.EjectSetting.ITEM)) {
            return true;
        }
        int i$ = 0;
        int[] arr$ = out;
        int len$ = arr$.length;
        if (i$ < len$) {
            Integer i = arr$[i$];
            if (this.inventory[i] == null) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private boolean hasMale() {
        return this.inventory[5] != null && Fishing.fishHelper.isMale(this.inventory[5]);
    }

    private boolean hasFemale() {
        return this.inventory[6] != null && Fishing.fishHelper.isFemale(this.inventory[6]);
    }

    private boolean fishCanLive(int slot) {
        if (MaricultureHandlers.upgrades.hasUpgrade("debugLive", this)) {
            return true;
        }
        if (this.tank.getFluid() == null || this.tank.getFluid() != null && this.tank.getFluid().fluidID != FluidRegistry.getFluidID((String)FluidDictionary.fish_food)) {
            return false;
        }
        ItemStack fish = this.inventory[slot];
        if (fish != null && fish.func_77942_o() && !Fishing.fishHelper.isEgg(fish)) {
            if (Fish.tankSize.getDNA(fish) > this.tankSize) {
                return false;
            }
            return Fishing.fishHelper.canLive(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, fish);
        }
        return false;
    }

    public int getLightValue() {
        FishSpecies species;
        int lM = 0;
        int lF = 0;
        if (this.inventory[5] != null && this.inventory[5].func_77942_o() && (species = Fishing.fishHelper.getSpecies(this.inventory[5])) != null && species.getLightValue() > 0) {
            lM = species.getLightValue();
        }
        if (this.inventory[6] != null && this.inventory[6].func_77942_o() && (species = Fishing.fishHelper.getSpecies(this.inventory[6])) != null && species.getLightValue() > 0) {
            lF = species.getLightValue();
        }
        if (lM == 0) {
            return lF;
        }
        if (lF == 0) {
            return lM;
        }
        return (lM + lF) / 2;
    }

    private void addFishFood() {
        for (CachedCoords coord : this.coords) {
            List list = this.field_70331_k.func_72872_a(EntityItem.class, Block.field_71981_t.func_71872_e(this.field_70331_k, coord.x, coord.y, coord.z));
            if (list.isEmpty()) continue;
            for (Object i : list) {
                EntityItem entity = (EntityItem)i;
                ItemStack item = entity.func_92059_d();
                if (!entity.func_70072_I() && (!entity.field_70170_p.field_73011_w.field_76575_d || !entity.func_70058_J()) || (item = this.addFishFood(item)) != null) continue;
                entity.func_70106_y();
            }
        }
    }

    private ItemStack addFishFood(ItemStack stack) {
        if (FishFoodHandler.isFishFood(stack)) {
            int increase = FishFoodHandler.getValue(stack);
            int loop = stack.field_77994_a;
            for (int i = 0; i < loop; ++i) {
                int fill = this.fill(ForgeDirection.UP, FluidRegistry.getFluidStack((String)FluidDictionary.fish_food, (int)increase), false);
                if (fill <= 0) continue;
                this.fill(ForgeDirection.UP, FluidRegistry.getFluidStack((String)FluidDictionary.fish_food, (int)increase), true);
                --stack.field_77994_a;
            }
        }
        if (stack.field_77994_a <= 0) {
            return null;
        }
        return stack;
    }

    private void processContainers() {
        ItemStack result = FluidHelper.getFluidResult(this, this.inventory[3], this.inventory[4]);
        if (result != null) {
            this.func_70298_a(3, 1);
            if (result.field_77993_c != Core.air.field_71990_ca) {
                if (this.inventory[4] == null) {
                    this.inventory[4] = result.func_77946_l();
                } else if (this.inventory[4].field_77993_c == result.field_77993_c) {
                    ++this.inventory[4].field_77994_a;
                }
            }
        }
    }

    public void updateTankSize() {
        int xP = 0;
        int xN = 0;
        int yP = 0;
        int yN = 0;
        int zP = 0;
        int zN = 0;
        ItemStack male = this.inventory[5];
        if (male != null) {
            xP = Fish.east.getDNA(male);
            xN = Fish.west.getDNA(male);
            yP = Fish.up.getDNA(male);
            yN = Fish.down.getDNA(male);
            zP = Fish.south.getDNA(male);
            zN = Fish.north.getDNA(male);
        }
        this.coords = new ArrayList();
        this.tankSize = 0;
        for (int x = -5 - xN; x <= 5 + xP; ++x) {
            for (int z = -5 - zN; z <= 5 + zP; ++z) {
                for (int y = -5 - yN; y <= 5 + yP; ++y) {
                    if (!BlockHelper.isFishLiveable(this.field_70331_k, this.field_70329_l + x, this.field_70330_m + y, this.field_70327_n + z)) continue;
                    this.coords.add(new CachedCoords(this.field_70329_l + x, this.field_70330_m + y, this.field_70327_n + z));
                    ++this.tankSize;
                }
            }
        }
    }

    private void doEffect(ItemStack fish) {
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null && !this.field_70331_k.field_72995_K) {
            species.affectWorld(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.coords);
            for (CachedCoords cord : this.coords) {
                List list = this.field_70331_k.func_72872_a(EntityLivingBase.class, Block.field_71981_t.func_71872_e(this.field_70331_k, cord.x, cord.y, cord.z));
                if (list.isEmpty()) continue;
                for (Object i : list) {
                    species.affectLiving((EntityLivingBase)i);
                }
            }
        }
    }

    private void generateEgg() {
        if (Fishing.fishHelper.getSpecies(this.inventory[5]) != null) {
            this.helper.insertStack(Fishing.fishHelper.generateEgg(this.inventory[5], this.inventory[6]), out);
        }
    }

    private void useFood(ItemStack fish) {
        int usage = 0;
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null) {
            usage = Fish.foodUsage.getDNA(fish);
            usage = usage == 0 && species.requiresFood() ? 1 : usage;
        }
        this.drain(ForgeDirection.UNKNOWN, FluidRegistry.getFluidStack((String)FluidDictionary.fish_food, (int)usage), true);
    }

    private void makeProduct(ItemStack fish) {
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null) {
            for (int i = 0; i < Fish.production.getDNA(fish); ++i) {
                int fertility;
                ItemStack product = species.getProduct(Rand.rand);
                if (product != null) {
                    this.helper.insertStack(product, out);
                }
                int gender = Fish.gender.getDNA(fish);
                if (MaricultureHandlers.upgrades.hasUpgrade("female", this) && Rand.nextInt(fertility = Math.max(1, 75 - Fish.fertility.getDNA(fish) / 75))) {
                    this.generateEgg();
                }
                if (!MaricultureHandlers.upgrades.hasUpgrade("male", this) || (product = species.getProduct(Rand.rand)) == null) continue;
                this.helper.insertStack(product, out);
            }
        }
    }

    private void damageFish(ItemStack fish, boolean giveProduct) {
        FishSpecies species = Fishing.fishHelper.getSpecies(fish);
        if (species != null) {
            int gender = Fish.gender.getDNA(fish);
            if (gender == FishHelper.FEMALE && MaricultureHandlers.upgrades.hasUpgrade("female", this)) {
                return;
            }
            if (gender == FishHelper.MALE && MaricultureHandlers.upgrades.hasUpgrade("male", this)) {
                return;
            }
            int reduce = this.max - this.purity * 15;
            fish.field_77990_d.func_74768_a("CurrentLife", fish.field_77990_d.func_74762_e("CurrentLife") - reduce);
            if (fish.field_77990_d.func_74762_e("CurrentLife") <= 0 || MaricultureHandlers.upgrades.hasUpgrade("debugKill", this)) {
                this.killFish(species, gender, giveProduct);
            }
        }
    }

    private void killFish(FishSpecies species, int gender, boolean giveProduct) {
        if (giveProduct) {
            ItemStack raw = new ItemStack(Fishery.fishyFood, 1, species.getID());
            if (raw != null) {
                this.helper.insertStack(raw, out);
            }
            if (gender == FishHelper.FEMALE) {
                this.generateEgg();
            } else if (gender == FishHelper.MALE) {
                this.updateTankSize();
            }
        }
        if (gender == FishHelper.FEMALE) {
            this.func_70298_a(6, 1);
        } else if (gender == FishHelper.MALE) {
            this.func_70298_a(5, 1);
        }
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        switch (type) {
            case NO_FOOD: {
                return this.tank.getFluid() == null || this.tank.getFluid() != null && this.tank.getFluid().fluidID != FluidRegistry.getFluidID((String)FluidDictionary.fish_food);
            }
            case NO_MALE: {
                return !this.hasMale();
            }
            case NO_FEMALE: {
                return !this.hasFemale();
            }
            case BAD_ENV: {
                return (this.hasFemale() || this.hasMale()) && !this.canWork;
            }
        }
        return false;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    public boolean addToolTip(ArrayList<String> tooltip, String text) {
        tooltip.add("\u00a7c" + text);
        return false;
    }

    public Environment.Salinity getSalinity() {
        Environment.Salinity salt = MaricultureHandlers.environment.getSalinity(this.field_70331_k, this.field_70329_l, this.field_70327_n);
        int salinity = salt.ordinal() + MaricultureHandlers.upgrades.getData("salinity", this);
        if (salinity <= 0) {
            salinity = 0;
        }
        if (salinity > 2) {
            salinity = 2;
        }
        salt = Environment.Salinity.values()[salinity];
        return salt;
    }

    public ArrayList<String> getTooltip(int slot, ArrayList<String> tooltip) {
        boolean noBad = true;
        ItemStack fish = this.inventory[slot];
        FishSpecies species = Fishing.fishHelper.getSpecies(this.inventory[slot]);
        if (fish != null && fish.func_77942_o() && !Fishing.fishHelper.isEgg(fish) && species != null) {
            int currentLife = fish.field_77990_d.func_74762_e("CurrentLife") / 20;
            if (!MaricultureHandlers.upgrades.hasUpgrade("debugLive", this)) {
                int size;
                int required;
                int temperature;
                if (!MaricultureHandlers.upgrades.hasUpgrade("ethereal", this) && !species.isWorldCorrect(this.field_70331_k)) {
                    noBad = this.addToolTip(tooltip, Text.translate("badWorld"));
                }
                if ((temperature = MaricultureHandlers.environment.getTemperature(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n) + this.heat) < species.temperature[0]) {
                    required = species.temperature[0] - temperature;
                    noBad = this.addToolTip(tooltip, Text.translate("tooCold"));
                    noBad = this.addToolTip(tooltip, "  +" + required + "\u00b0C");
                } else if (temperature > species.temperature[1]) {
                    required = temperature - species.temperature[1];
                    noBad = this.addToolTip(tooltip, Text.translate("tooHot"));
                    noBad = this.addToolTip(tooltip, "  -" + required + "\u00b0C");
                }
                boolean match = false;
                Environment.Salinity salt = this.getSalinity();
                for (Environment.Salinity salinity : species.salinity) {
                    if (salt != salinity) continue;
                    match = true;
                    break;
                }
                if (!match) {
                    for (Environment.Salinity salinity : species.salinity) {
                        noBad = this.addToolTip(tooltip, Text.translate("salinity.prefers") + " " + Text.translate("salinity." + salinity.toString().toLowerCase()));
                    }
                }
                if (this.tankSize < (size = Fish.tankSize.getDNA(fish).intValue())) {
                    noBad = this.addToolTip(tooltip, Text.translate("notAdvanced"));
                    String text = this.field_70331_k.field_73011_w.field_76575_d ? Text.translate("blocks.lava") : Text.translate("blocks.water");
                    noBad = this.addToolTip(tooltip, "  +" + (size - this.tankSize) + " " + text);
                }
                if (!species.canWork(Environment.Time.getTime(this.field_70331_k))) {
                    noBad = this.addToolTip(tooltip, Text.translate("badTime"));
                }
                if (!this.hasMale() || !this.hasFemale()) {
                    noBad = this.addToolTip(tooltip, Text.translate("missingMate"));
                }
                if (this.tank.getFluidAmount() < 1 || this.tank.getFluid().fluidID != FluidDictionary.getFluid(FluidDictionary.fish_food).getID()) {
                    noBad = this.addToolTip(tooltip, Text.translate("noFood"));
                }
                if (noBad) {
                    tooltip.add("\u00a72" + currentLife + " HP");
                }
            } else if (this.hasMale() && this.hasFemale()) {
                tooltip.add("\u00a72" + currentLife + " HP");
            }
        }
        return tooltip;
    }

    public int getFishLifeScaled(int slot, int scale) {
        ItemStack fish = this.inventory[slot];
        if (fish != null && fish.func_77942_o() && !Fishing.fishHelper.isEgg(fish) && fish.field_77990_d.func_74764_b("SpeciesID")) {
            int maxLife = fish.field_77990_d.func_74762_e("Lifespan");
            int currentLife = fish.field_77990_d.func_74762_e("CurrentLife");
            if (slot == 5 && !this.hasFemale() || slot == 6 && !this.hasMale()) {
                return -1;
            }
            if (this.fishCanLive(slot)) {
                return currentLife * scale / maxLife;
            }
            return -1;
        }
        return 0;
    }

    public Packet func_70319_e() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_70310_b(tag);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 1, tag);
    }

    public void onDataPacket(INetworkManager net, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.tankSize = nbt.func_74762_e("TankSize");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("TankSize", this.tankSize);
    }
}

