/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery.blocks;

import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.ItemBaseRod;
import mariculture.api.fishery.RodQuality;
import mariculture.core.blocks.base.TileMachinePowered;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.lib.Extra;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.util.IHasNotification;
import mariculture.core.util.Rand;
import mariculture.magic.Magic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileAutofisher
extends TileMachinePowered
implements IHasNotification {
    private int baitQuality = -1;
    public static final int rod = 4;
    public static final int[] bait = new int[]{5, 6, 7, 8, 9, 10};
    public static final int[] out = new int[]{11, 12, 13, 14, 15, 16, 17, 18, 19};

    public TileAutofisher() {
        this.max = MachineSpeeds.getAutofisherSpeed();
        this.inventory = new ItemStack[20];
        this.setting = FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public int getRFCapacity() {
        return 20000;
    }

    public int[] func_94128_d(int side) {
        if (side <= 1) {
            return new int[]{4};
        }
        return new int[]{5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 4 && stack.func_77973_b() instanceof ItemBaseRod) {
            return true;
        }
        return slot >= 5 && slot <= 10 && Fishing.bait.getBaitQuality(stack) > 0;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 11 || slot == 4;
    }

    @Override
    public void updateMachine() {
        if (!this.field_70331_k.field_72995_K) {
            if (this.canWork) {
                this.energyStorage.extractEnergy(this.getRFUsage(), false);
                if (this.baitQuality == -1 && this.canWork()) {
                    this.baitQuality = this.inventory[4].field_77993_c == Item.field_77749_aR.field_77779_bT ? 33 : this.getBaitQualityAndDelete();
                } else {
                    this.processed += this.speed;
                    if (this.processed >= this.max) {
                        this.processed = 0;
                        int bonusQuality = this.baitQuality + EnchantHelper.getLevel(Magic.luck, this.inventory[4]) * 3;
                        if (Rand.rand.nextInt(100) < bonusQuality && this.canWork()) {
                            this.catchFish();
                        }
                        this.baitQuality = -1;
                    }
                    if (this.processed <= 0) {
                        this.processed = 0;
                    }
                }
            } else {
                this.baitQuality = -1;
                this.processed = 0;
            }
        }
    }

    @Override
    public boolean canWork() {
        return this.hasRod() && this.isFishable() && this.hasPower() && FeatureRedstone.RedstoneMode.canWork(this, this.mode) && this.hasRoom() && (this.baitQuality != -1 || this.hasBait() && this.canUseRod());
    }

    public boolean hasRoom() {
        if (this.setting.canEject(FeatureEject.EjectSetting.ITEM)) {
            return true;
        }
        int i$ = 0;
        int[] arr$ = out;
        int len$ = arr$.length;
        if (i$ < len$) {
            Integer i = arr$[i$];
            if (this.inventory[i] == null) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private boolean canUseRod() {
        if (this.inventory[4].field_77993_c == Item.field_77749_aR.field_77779_bT) {
            return true;
        }
        RodQuality quality = ((ItemBaseRod)this.inventory[4].func_77973_b()).getQuality();
        for (int i : bait) {
            if (this.inventory[i] == null) continue;
            return Fishing.quality.canUseBait(this.inventory[i], quality);
        }
        return false;
    }

    private boolean hasBait() {
        if (this.inventory[4] != null && this.inventory[4].field_77993_c == Item.field_77749_aR.field_77779_bT) {
            return true;
        }
        for (int i : bait) {
            if (this.inventory[i] == null) continue;
            return Fishing.bait.getBaitQuality(this.inventory[i]) > 0;
        }
        return false;
    }

    private boolean hasPower() {
        return this.energyStorage.extractEnergy(this.getRFUsage(), true) >= this.getRFUsage();
    }

    public boolean isFishable() {
        return BlockHelper.isFishable(this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
    }

    private boolean hasRod() {
        if (this.inventory[4] != null) {
            if (this.inventory[4].field_77993_c == Item.field_77749_aR.field_77779_bT) {
                return true;
            }
            if (this.inventory[4].func_77973_b() instanceof ItemBaseRod) {
                return ((ItemBaseRod)this.inventory[4].func_77973_b()).canFish(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, null, this.inventory[4]);
            }
        }
        return false;
    }

    private int getChance(int quality) {
        switch (quality) {
            case 5: {
                return Extra.bait5;
            }
            case 4: {
                return Extra.bait4;
            }
            case 3: {
                return Extra.bait3;
            }
            case 2: {
                return Extra.bait2;
            }
            case 1: {
                return Extra.bait1;
            }
            case 0: {
                return Extra.bait0;
            }
        }
        return 0;
    }

    private int getSuitableSlot(ItemStack item) {
        for (int i : out) {
            if (this.inventory[i] == null) {
                return i;
            }
            if (!ItemStack.func_77989_b((ItemStack)this.inventory[i], (ItemStack)item)) continue;
            return i;
        }
        return -1;
    }

    private int getBaitQualityAndDelete() {
        RodQuality quality = ((ItemBaseRod)this.inventory[4].func_77973_b()).getQuality();
        for (int i : bait) {
            if (this.inventory[i] == null || !Fishing.quality.canUseBait(this.inventory[i], quality)) continue;
            int qual = Fishing.bait.getBaitQuality(this.inventory[i]);
            this.func_70298_a(i, 1);
            return qual;
        }
        return -1;
    }

    public int getRFUsage() {
        return 12 + this.speed * 8;
    }

    private void catchFish() {
        ItemStack lootResult = null;
        if (this.inventory[4].field_77993_c == Item.field_77749_aR.field_77779_bT) {
            lootResult = new ItemStack(Item.field_77754_aU);
            this.inventory[4].func_96631_a(1, Rand.rand);
        } else {
            RodQuality quality = ((ItemBaseRod)this.inventory[4].func_77973_b()).getQuality();
            if (quality == null) {
                quality = RodQuality.OLD;
            }
            lootResult = Fishing.loot.getLoot(Rand.rand, quality, this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
            this.inventory[4] = ((ItemBaseRod)this.inventory[4].func_77973_b()).damage(this.field_70331_k, null, this.inventory[4], 0);
        }
        if (lootResult != null) {
            this.helper.insertStack(lootResult, out);
        }
        if (this.inventory[4] == null || this.inventory[4].func_77960_j() > this.inventory[4].func_77958_k()) {
            this.inventory[4] = null;
            this.canWork = this.canWork();
        }
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        switch (type) {
            case NO_ROD: {
                return !this.hasRod();
            }
            case NO_BAIT: {
                return !this.hasBait() || !this.hasRod() || !this.canUseRod();
            }
            case NOT_FISHABLE: {
                return !this.isFishable();
            }
            case NO_RF: {
                return !this.hasPower();
            }
        }
        return false;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.baitQuality = nbt.func_74762_e("BaitQuality");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("BaitQuality", this.baitQuality);
    }
}

