/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import java.util.ArrayList;
import java.util.List;
import mariculture.api.fishery.IRodQuality;
import mariculture.api.fishery.RodQuality;
import net.minecraft.item.ItemStack;

public class RodQualityHandler
implements IRodQuality {
    private static ArrayList<FishingRod> canUseBait = new ArrayList();

    static ArrayList<FishingRod> getCanUseList() {
        return canUseBait;
    }

    @Override
    public void addBaitForQuality(ItemStack bait, List<RodQuality> rods) {
        for (int i = 0; i < rods.size(); ++i) {
            if (!(rods.get(i) instanceof RodQuality)) continue;
            this.addBaitForQuality(bait, rods.get(i));
        }
    }

    @Override
    public void removeBaitForQuality(ItemStack bait, List<RodQuality> rods) {
        for (int i = 0; i < rods.size(); ++i) {
            if (!(rods.get(i) instanceof RodQuality)) continue;
            this.removeBaitForQuality(bait, rods.get(i));
        }
    }

    @Override
    public void addBaitForQuality(ItemStack bait, RodQuality quality) {
        canUseBait.add(new FishingRod(bait, quality));
    }

    @Override
    public void removeBaitForQuality(ItemStack bait, RodQuality quality) {
        ArrayList lootTmp = (ArrayList)canUseBait.clone();
        for (FishingRod loot : lootTmp) {
            if (!loot.equals(bait, quality)) continue;
            canUseBait.remove(loot);
        }
    }

    @Override
    public boolean canUseBait(ItemStack stack, RodQuality quality) {
        ArrayList lootTmp = (ArrayList)canUseBait.clone();
        for (FishingRod loot : lootTmp) {
            if (!loot.equals(stack, quality)) continue;
            return true;
        }
        return false;
    }

    static class FishingRod {
        ItemStack itemStack;
        RodQuality enumQuality;

        private FishingRod(ItemStack item, RodQuality quality) {
            this.itemStack = item;
            this.enumQuality = quality;
        }

        private boolean equals(ItemStack item, RodQuality quality) {
            return quality == this.enumQuality && item.func_77969_a(this.itemStack);
        }
    }
}

