/*
 * Decompiled with CFR 0.152.
 */
package mariculture.fishery;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import mariculture.api.core.EnumBiomeType;
import mariculture.api.core.EnumSalinityType;
import mariculture.api.core.Environment;
import mariculture.api.core.IUpgradable;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.IFishHelper;
import mariculture.api.fishery.fish.FishDNABase;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.handlers.LogHandler;
import mariculture.core.helpers.AverageHelper;
import mariculture.fishery.Fish;
import mariculture.fishery.FishMutationHandler;
import mariculture.fishery.Fishery;
import mariculture.fishery.items.ItemFishy;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class FishHelper
implements IFishHelper {
    public static int MALE = 0;
    public static int FEMALE = 1;

    @Override
    public ItemStack makePureFish(FishSpecies species) {
        ItemStack fishStack = new ItemStack(Fishery.fishy);
        if (!fishStack.func_77942_o()) {
            fishStack.func_77982_d(new NBTTagCompound());
        }
        for (int i = 0; i < FishDNABase.DNAParts.size(); ++i) {
            FishDNABase.DNAParts.get(i).addDNA(fishStack, FishDNABase.DNAParts.get(i).getDNAFromSpecies(species));
            FishDNABase.DNAParts.get(i).addLowerDNA(fishStack, FishDNABase.DNAParts.get(i).getDNAFromSpecies(species));
        }
        return fishStack;
    }

    public static int[] swapDominance(int dominance1, int dominance2, int option1, int option2, Random rand) {
        int[] array = new int[2];
        if (dominance1 == dominance2) {
            if (rand.nextInt(2) == 0) {
                array[0] = option1;
                array[1] = option2;
            } else {
                array[0] = option2;
                array[1] = option1;
            }
        } else if (dominance1 < dominance2) {
            array[0] = option1;
            array[1] = option2;
        } else {
            array[0] = option2;
            array[1] = option1;
        }
        return array;
    }

    @Override
    public ItemStack makeBredFish(ItemStack egg, Random rand) {
        return this.makeBredFish(egg, rand, 1.0);
    }

    @Override
    public ItemStack makeBredFish(ItemStack egg, Random rand, double modifier) {
        int i;
        ItemStack fish = new ItemStack(Fishery.fishy);
        for (i = 0; i < FishDNABase.DNAParts.size(); ++i) {
            if (FishDNABase.DNAParts.get(i).hasEggData(egg)) continue;
            return null;
        }
        for (i = 0; i < FishDNABase.DNAParts.size(); ++i) {
            int[] DNAlist = FishDNABase.DNAParts.get(i).getDNAList(egg);
            int parent1DNA = DNAlist[rand.nextInt(2)];
            int parent2DNA = DNAlist[rand.nextInt(2) + 2];
            int[] babyDNA = FishDNABase.DNAParts.get(i).attemptMutation(parent1DNA, parent2DNA);
            FishDNABase.DNAParts.get(i).addDNA(fish, babyDNA[0]);
            FishDNABase.DNAParts.get(i).addLowerDNA(fish, babyDNA[1]);
        }
        int species1 = Fish.species.getDNA(fish);
        int species2 = Fish.species.getLowerDNA(fish);
        ArrayList<FishMutationHandler.Mutation> mutations = Fishing.mutation.getMutations(this.getSpecies(species1), this.getSpecies(species2));
        if (species1 != species2 && mutations != null && mutations.size() > 0) {
            for (FishMutationHandler.Mutation mute : mutations) {
                int i2;
                FishSpecies baby = Fishing.fishHelper.getSpecies(mute.baby);
                if (baby == null) continue;
                if ((double)rand.nextInt(1000) < mute.chance * 10.0 * modifier) {
                    for (i2 = 0; i2 < FishDNABase.DNAParts.size(); ++i2) {
                        FishDNABase.DNAParts.get(i2).addDNA(fish, FishDNABase.DNAParts.get(i2).getDNAFromSpecies(baby));
                    }
                }
                if (!((double)rand.nextInt(1000) < mute.chance * 10.0 * modifier)) continue;
                for (i2 = 0; i2 < FishDNABase.DNAParts.size(); ++i2) {
                    FishDNABase.DNAParts.get(i2).addDNA(fish, FishDNABase.DNAParts.get(i2).getDNAFromSpecies(baby));
                }
            }
        }
        for (int i3 = 0; i3 < FishDNABase.DNAParts.size(); ++i3) {
            int dna1 = FishDNABase.DNAParts.get(i3).getDNA(fish);
            int dna2 = FishDNABase.DNAParts.get(i3).getLowerDNA(fish);
            int[] dominance = FishDNABase.DNAParts.get(i3).getDominant(dna1, dna2, rand);
            FishDNABase.DNAParts.get(i3).addDNA(fish, dominance[0]);
            FishDNABase.DNAParts.get(i3).addLowerDNA(fish, dominance[1]);
        }
        Fish.gender.addDNA(fish, rand.nextInt(2));
        return fish;
    }

    @Override
    public boolean canLive(World world, int x, int y, int z, ItemStack stack) {
        FishSpecies fish = FishSpecies.species.get(Fish.species.getDNA(stack));
        Environment.Salinity salt = MaricultureHandlers.environment.getSalinity(world, x, z);
        int temperature = MaricultureHandlers.environment.getTemperature(world, x, y, z);
        boolean worldCorrect = fish.isWorldCorrect(world);
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile != null && tile instanceof IUpgradable) {
            IUpgradable upgradable = (IUpgradable)tile;
            temperature += MaricultureHandlers.upgrades.getData("temp", upgradable);
            int salinity = salt.ordinal() + MaricultureHandlers.upgrades.getData("salinity", upgradable);
            if (salinity <= 0) {
                salinity = 0;
            }
            if (salinity > 2) {
                salinity = 2;
            }
            salt = Environment.Salinity.values()[salinity];
            if (!worldCorrect) {
                worldCorrect = MaricultureHandlers.upgrades.hasUpgrade("ethereal", upgradable);
            }
        }
        if (!worldCorrect) {
            return false;
        }
        if (fish != null) {
            if (!fish.canWork(Environment.Time.getTime(world))) {
                return false;
            }
            return MaricultureHandlers.environment.matches(salt, temperature, fish.salinity, fish.temperature);
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean canLive(BiomeGenBase biome, EnumBiomeType[] biomeTypes, EnumSalinityType[] salinity, TileEntity tile) {
        LogHandler.log(Level.WARNING, "Please warn mod authors that this method is deprecated in Mariculture, CAN LIVE, using EnumBiomes and EnumSalinity");
        if (tile instanceof IUpgradable) {
            IUpgradable upgradable = (IUpgradable)tile;
            EnumBiomeType theBiome = MaricultureHandlers.biomeType.getBiomeType(tile.field_70331_k.func_72807_a(tile.field_70329_l, tile.field_70327_n));
            EnumSalinityType saltType = theBiome.getSalinity();
            if (MaricultureHandlers.upgrades.hasUpgrade("salinator", upgradable)) {
                saltType = EnumSalinityType.SALT;
            }
            if (MaricultureHandlers.upgrades.hasUpgrade("filter", upgradable)) {
                saltType = EnumSalinityType.FRESH;
            }
            if (MaricultureHandlers.upgrades.hasUpgrade("ethereal", upgradable)) {
                saltType = EnumSalinityType.MAGIC;
            }
            boolean saltMatches = false;
            for (EnumSalinityType salt : salinity) {
                if (!salt.equals((Object)saltType)) continue;
                saltMatches = true;
            }
            if (!saltMatches) {
                return false;
            }
            int min = biomeTypes[0].minTemp();
            int max = biomeTypes[0].maxTemp();
            int temp = theBiome.baseTemp() + MaricultureHandlers.upgrades.getData("temp", (IUpgradable)tile);
            for (EnumBiomeType type : biomeTypes) {
                if (type.minTemp() < min) {
                    min = type.minTemp();
                }
                if (type.maxTemp() <= max) continue;
                max = type.maxTemp();
            }
            if (temp >= min && temp <= max) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean biomeMatches(BiomeGenBase biome, EnumBiomeType[] biomeTypes) {
        LogHandler.log(Level.WARNING, "Deprecated method was called in Mariculture");
        return false;
    }

    @Override
    public boolean isPure(ItemStack stack) {
        return Fish.species.getDNA(stack) == Fish.species.getLowerDNA(stack);
    }

    @Override
    public boolean isMale(ItemStack stack) {
        return Fish.gender.getDNA(stack) == MALE;
    }

    @Override
    public boolean isFemale(ItemStack stack) {
        return Fish.gender.getDNA(stack) == FEMALE;
    }

    @Override
    public boolean isEgg(ItemStack stack) {
        return this.isFishItem(stack) && stack.func_77960_j() == 1;
    }

    private boolean isFishItem(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || stack.field_77994_a < 1 || !stack.func_77942_o()) {
            return false;
        }
        return stack.func_77973_b() instanceof ItemFishy;
    }

    @Override
    public ItemStack generateEgg(ItemStack fish1, ItemStack fish2) {
        ItemStack egg = new ItemStack(Fishery.fishy, 1, 1);
        egg.func_77982_d(new NBTTagCompound());
        for (int i = 0; i < FishDNABase.DNAParts.size(); ++i) {
            int[] DNAlist = new int[]{FishDNABase.DNAParts.get(i).getDNA(fish1), FishDNABase.DNAParts.get(i).getLowerDNA(fish1), FishDNABase.DNAParts.get(i).getDNA(fish2), FishDNABase.DNAParts.get(i).getLowerDNA(fish2)};
            FishDNABase.DNAParts.get(i).addDNAList(egg, DNAlist);
        }
        int[] fertility = egg.field_77990_d.func_74759_k(Fish.fertility.getEggString());
        int eggLife = AverageHelper.getMode(fertility);
        egg.field_77990_d.func_74768_a("currentFertility", eggLife);
        egg.field_77990_d.func_74768_a("malesGenerated", 0);
        egg.field_77990_d.func_74768_a("femalesGenerated", 0);
        return egg;
    }

    @Override
    public FishSpecies getSpecies(String species) {
        for (Map.Entry<Integer, FishSpecies> speciesList : FishSpecies.species.entrySet()) {
            FishSpecies fish = speciesList.getValue();
            if (!fish.getSpecies().equals(species)) continue;
            return fish;
        }
        return Fish.cod;
    }

    @Override
    public FishSpecies getSpecies(int id) {
        return FishSpecies.species.get(id);
    }

    @Override
    public FishSpecies getSpecies(ItemStack stack) {
        if (stack == null || !stack.func_77942_o() || stack.func_77960_j() == 1 || stack.field_77994_a < 1) {
            return null;
        }
        return FishSpecies.species.get(Fish.species.getDNA(stack));
    }

    @Override
    public int getSpeciesID(String species) {
        for (Map.Entry<Integer, FishSpecies> speciesList : FishSpecies.species.entrySet()) {
            FishSpecies fish = speciesList.getValue();
            if (!fish.getSpecies().equals(species)) continue;
            return speciesList.getKey();
        }
        return 0;
    }

    @Override
    public Integer getDNA(String str, ItemStack stack) {
        for (FishDNABase dna : FishDNABase.DNAParts) {
            if (!str.equals(dna.getName())) continue;
            return dna.getDNA(stack);
        }
        return -1;
    }

    @Override
    public Integer getLowerDNA(String str, ItemStack stack) {
        for (FishDNABase dna : FishDNABase.DNAParts) {
            if (!str.equals(dna.getName())) continue;
            return dna.getLowerDNA(stack);
        }
        return -1;
    }
}

