/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.util.FluidDictionary;
import mariculture.core.util.Rand;
import mariculture.factory.blocks.TileTurbineBase;
import mariculture.factory.items.ItemRotor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class TileTurbineWater
extends TileTurbineBase {
    @Override
    public int getTankCapacity() {
        return 4000 + this.storage * 1000 * 2;
    }

    @Override
    public int getRFCapacity() {
        return 20000 + this.rf;
    }

    @Override
    public int getEnergyGenerated() {
        return 3 + this.speed * 3;
    }

    @Override
    public int getEnergyTransferMax() {
        return 75;
    }

    @Override
    public boolean canOperate() {
        if (this.inventory[6] == null) {
            return false;
        }
        if (!FeatureRedstone.RedstoneMode.canWork(this, this.mode)) {
            return false;
        }
        ItemStack rotor = this.inventory[6];
        if (rotor.func_77973_b() instanceof ItemRotor) {
            return ((ItemRotor)this.inventory[6].func_77973_b()).isTier(2);
        }
        return false;
    }

    @Override
    public void addPower() {
        FluidStack fluid = this.tank.getFluid();
        if (fluid != null && this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored()) {
            String name = fluid.getFluid().getName();
            if (name.equals(FluidDictionary.hp_water)) {
                if (this.onTick(200) && this.inventory[6].func_96631_a(1, Rand.rand)) {
                    this.inventory[6] = null;
                    return;
                }
                this.isCreatingPower = true;
                if (Rand.rand.nextInt(this.purity * 10 >= 1 ? this.purity * 10 : 1) < 1) {
                    this.tank.drain(this.speed, true);
                }
                this.energyStorage.modifyEnergyStored(this.getEnergyGenerated());
            } else {
                this.isCreatingPower = false;
            }
        } else {
            this.isCreatingPower = false;
        }
    }

    public int[] func_94128_d(int side) {
        return new int[]{3, 4, 6};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 3 && FluidHelper.isFluidOrEmpty(stack) || slot == 6 && stack.func_77973_b() instanceof ItemRotor;
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot == 4;
    }
}

