/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import mariculture.api.core.IBlacklisted;
import mariculture.core.Core;
import mariculture.core.blocks.base.TileTank;
import mariculture.core.helpers.BlockTransferHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.cofh.BlockHelper;
import mariculture.core.util.FluidDictionary;
import mariculture.core.util.Tank;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetworkManager;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet132TileEntityData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileSluice
extends TileTank
implements IBlacklisted {
    protected BlockTransferHelper helper;
    public ForgeDirection direction = ForgeDirection.UP;
    protected int machineTick;
    private int height = 0;

    public TileSluice() {
        this.tank = new Tank(10000);
    }

    @Override
    public boolean isBlacklisted(World world, int x, int y, int z) {
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean onTick(int i) {
        return this.machineTick % i == 0;
    }

    public void func_70316_g() {
        if (this.helper == null) {
            this.helper = new BlockTransferHelper(this);
        }
        ++this.machineTick;
        if (this.onTick(200) && this.direction.ordinal() > 1) {
            this.generateHPWater();
        }
        if (this.onTick(60)) {
            this.placeInTank();
            this.pullFromTank();
            this.switchTanks();
        }
        if (this.onTick(30) && this.tank.getFluidAmount() > 0 && this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            this.helper.ejectFluid(new int[]{1000, 500, 100, 20, 10, 1});
        }
    }

    public void placeInTank() {
        int z2;
        int y2;
        int x2;
        Block block;
        TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, this.direction);
        if (tile != null && tile instanceof IFluidHandler && ((block = Block.field_71973_m[this.field_70331_k.func_72798_a(x2 = this.field_70329_l - this.direction.offsetX, y2 = this.field_70330_m - this.direction.offsetY, z2 = this.field_70327_n - this.direction.offsetZ)]) instanceof BlockFluidBase || block instanceof BlockFluid)) {
            IFluidHandler tank;
            FluidStack fluid = null;
            if (block instanceof BlockFluidBase) {
                fluid = ((BlockFluidBase)block).drain(this.field_70331_k, x2, y2, z2, false);
            }
            if (mariculture.core.helpers.BlockHelper.isWater(this.field_70331_k, x2, y2, z2)) {
                fluid = FluidRegistry.getFluidStack((String)"water", (int)1000);
            }
            if (mariculture.core.helpers.BlockHelper.isLava(this.field_70331_k, x2, y2, z2)) {
                fluid = FluidRegistry.getFluidStack((String)"lava", (int)1000);
            }
            if (fluid != null && (tank = (IFluidHandler)tile).fill(this.direction, fluid, false) >= fluid.amount) {
                if (block instanceof BlockFluidBase) {
                    ((BlockFluidBase)block).drain(this.field_70331_k, x2, y2, z2, true);
                } else {
                    this.field_70331_k.func_94571_i(x2, y2, z2);
                }
                tank.fill(this.direction, fluid, true);
            }
        }
    }

    public void pullFromTank() {
        int z2;
        int y2;
        int x2;
        TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, this.direction.getOpposite());
        if (tile != null && tile instanceof IFluidHandler && this.field_70331_k.func_72799_c(x2 = this.field_70329_l + this.direction.offsetX, y2 = this.field_70330_m + this.direction.offsetY, z2 = this.field_70327_n + this.direction.offsetZ)) {
            IFluidHandler tank = (IFluidHandler)tile;
            FluidTankInfo[] info = tank.getTankInfo(this.direction.getOpposite());
            if (info == null || info.length < 1) {
                return;
            }
            for (FluidTankInfo tanks : info) {
                int id;
                Fluid fluid;
                if (tanks.fluid == null || !(fluid = tanks.fluid.getFluid()).canBePlacedInWorld()) continue;
                int drain = FluidHelper.getRequiredVolumeForBlock(fluid);
                if (tank.drain(this.direction.getOpposite(), drain, false) == null) {
                    return;
                }
                if (tank.drain((ForgeDirection)this.direction.getOpposite(), (int)drain, (boolean)false).amount != drain || Block.field_71973_m[id = fluid.getBlockID()] == null) continue;
                Block block = Block.field_71973_m[id];
                FluidStack stack = tank.drain(this.direction.getOpposite(), new FluidStack(fluid.getID(), drain), false);
                if (stack == null) {
                    return;
                }
                if (block instanceof BlockFluidFinite) {
                    if (this.field_70331_k.func_72799_c(x2, y2, z2)) {
                        this.field_70331_k.func_72832_d(x2, y2, z2, id, 0, 2);
                    } else {
                        int meta = this.field_70331_k.func_72805_g(x2, y2, z2) + 1;
                        if (meta < 7 && this.field_70331_k.func_72798_a(x2, y2, z2) == id) {
                            this.field_70331_k.func_72921_c(x2, y2, z2, meta, 2);
                        } else {
                            return;
                        }
                    }
                    tank.drain(this.direction.getOpposite(), new FluidStack(fluid.getID(), drain), true);
                    continue;
                }
                if (!this.field_70331_k.func_72799_c(x2, y2, z2)) continue;
                this.field_70331_k.func_94575_c(x2, y2, z2, id);
                tank.drain(this.direction.getOpposite(), new FluidStack(fluid.getID(), drain), true);
            }
        }
    }

    public void switchTanks() {
        int x2 = this.field_70329_l + this.direction.offsetX;
        int y2 = this.field_70330_m + this.direction.offsetY;
        int z2 = this.field_70327_n + this.direction.offsetZ;
        int x3 = this.field_70329_l + this.direction.getOpposite().offsetX;
        int y3 = this.field_70330_m + this.direction.getOpposite().offsetY;
        int z3 = this.field_70327_n + this.direction.getOpposite().offsetZ;
        if (this.field_70331_k.func_72796_p(x2, y2, z2) instanceof IFluidHandler && this.field_70331_k.func_72796_p(x3, y3, z3) instanceof IFluidHandler) {
            IFluidHandler tankFrom = (IFluidHandler)this.field_70331_k.func_72796_p(x3, y3, z3);
            IFluidHandler tankTo = (IFluidHandler)this.field_70331_k.func_72796_p(x2, y2, z2);
            if (tankTo instanceof TileSluice) {
                return;
            }
            FluidStack fluid = tankFrom.drain(this.direction, 1000, false);
            if (fluid == null) {
                return;
            }
            int drained = tankTo.fill(this.direction.getOpposite(), fluid, false);
            if (drained > 0) {
                FluidStack drain = tankFrom.drain(this.direction, drained, true);
                tankTo.fill(this.direction.getOpposite(), drain, true);
            }
        }
    }

    public void generateHPWater() {
        int x = this.field_70329_l + this.direction.offsetX;
        int z = this.field_70327_n + this.direction.offsetZ;
        if (mariculture.core.helpers.BlockHelper.isWater(this.field_70331_k, this.field_70329_l - this.direction.offsetX, this.field_70330_m, this.field_70327_n - this.direction.offsetZ)) {
            if (mariculture.core.helpers.BlockHelper.isAir(this.field_70331_k, x, this.field_70330_m, z)) {
                this.field_70331_k.func_94575_c(x, this.field_70330_m, z, Core.highPressureWaterBlock.field_71990_ca);
            }
        } else if (mariculture.core.helpers.BlockHelper.isHPWater(this.field_70331_k, x, this.field_70330_m, z)) {
            this.field_70331_k.func_94571_i(x, this.field_70330_m, z);
        }
        if (mariculture.core.helpers.BlockHelper.isHPWater(this.field_70331_k, x, this.field_70330_m, z)) {
            this.height = 0;
            while (mariculture.core.helpers.BlockHelper.isWater(this.field_70331_k, this.field_70329_l - this.direction.offsetX, this.field_70330_m + this.height, this.field_70327_n - this.direction.offsetZ)) {
                ++this.height;
            }
            this.tank.fill(FluidRegistry.getFluidStack((String)FluidDictionary.hp_water, (int)(this.height * 10)), true);
        }
    }

    public Packet func_70319_e() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70310_b(nbt);
        return new Packet132TileEntityData(this.field_70329_l, this.field_70330_m, this.field_70327_n, 2, nbt);
    }

    public void onDataPacket(INetworkManager netManager, Packet132TileEntityData packet) {
        this.func_70307_a(packet.field_73331_e);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.direction = ForgeDirection.values()[nbt.func_74762_e("Orientation")];
        this.height = nbt.func_74762_e("Height");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("Orientation", this.direction.ordinal());
        nbt.func_74768_a("Height", this.height);
    }
}

