/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import mariculture.core.blocks.base.TileMultiBlock;
import mariculture.core.blocks.base.TileMultiMachineTank;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.util.FluidDictionary;
import mariculture.factory.items.ItemArmorFLUDD;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class TilePressureVessel
extends TileMultiMachineTank {
    public static final int in = 3;
    public static final int out = 4;
    public static final int fludd = 5;

    public TilePressureVessel() {
        this.inventory = new ItemStack[6];
        this.setting = FeatureEject.EjectSetting.NONE;
        this.mode = FeatureRedstone.RedstoneMode.DISABLED;
    }

    @Override
    public int getTankCapacity(int storage) {
        int tankRate = 1000;
        return (140 * tankRate + storage * 8 * tankRate) * (this.slaves.size() + 1);
    }

    public int[] func_94128_d(int side) {
        return new int[]{3, 4, 5};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (slot == 3) {
            return FluidHelper.isFluidOrEmpty(stack);
        }
        return slot == 5;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 4;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.FLUID;
    }

    @Override
    public void updateMasterMachine() {
        if (this.onTick(30) && this.tank.getFluidAmount() > 0 && FeatureRedstone.RedstoneMode.canWork(this, this.mode) && FeatureEject.EjectSetting.canEject(this.setting, FeatureEject.EjectSetting.FLUID)) {
            this.helper.ejectFluid(new int[]{this.speed * 100, 100, 50, 25, 10, 5, 1});
        }
        if (this.onTick(20)) {
            this.fillFLUDD();
        }
    }

    @Override
    public void updateSlaveMachine() {
        TilePressureVessel mstr;
        if (this.onTick(30) && (mstr = (TilePressureVessel)this.getMaster()) != null && this.tank.getFluidAmount() > 0 && FeatureRedstone.RedstoneMode.canWork(this, mstr.mode) && FeatureEject.EjectSetting.canEject(mstr.setting, FeatureEject.EjectSetting.FLUID)) {
            this.helper.ejectFluid(new int[]{((TilePressureVessel)this.getMaster()).speed * 100, 100, 50, 25, 10, 5, 1});
        }
    }

    private void fillFLUDD() {
        if (this.inventory[5] != null && this.inventory[5].func_77973_b() instanceof ItemArmorFLUDD && this.tank.getFluidID() == FluidRegistry.getFluidID((String)FluidDictionary.hp_water) && this.tank.getFluidAmount() > 0) {
            ItemStack stack = this.inventory[5].func_77946_l();
            int water = 0;
            if (stack.func_77942_o()) {
                water = stack.field_77990_d.func_74762_e("water");
            }
            if (water + this.speed * 100 < 20000 && this.tank.getFluidAmount() >= this.speed * 100) {
                stack.field_77990_d.func_74768_a("water", water + this.speed * 100);
                this.drain(ForgeDirection.UNKNOWN, this.speed * 100, true);
            } else if (water + 100 < 20000 && this.tank.getFluidAmount() >= 100) {
                stack.field_77990_d.func_74768_a("water", water + 100);
                this.drain(ForgeDirection.UNKNOWN, 100, true);
            } else if (water + 50 < 20000 && this.tank.getFluidAmount() >= 50) {
                stack.field_77990_d.func_74768_a("water", water + 50);
                this.drain(ForgeDirection.UNKNOWN, 50, true);
            } else if (water + 10 < 20000 && this.tank.getFluidAmount() >= 100) {
                stack.field_77990_d.func_74768_a("water", water + 10);
                this.drain(ForgeDirection.UNKNOWN, 10, true);
            } else if (water + 1 < 20000 && this.tank.getFluidAmount() >= 1) {
                stack.field_77990_d.func_74768_a("water", water + 1);
                this.drain(ForgeDirection.UNKNOWN, 1, true);
            }
            this.inventory[5] = stack;
        }
    }

    @Override
    public boolean canWork() {
        return false;
    }

    public TilePressureVessel isSameBlock(int x, int y, int z) {
        TileEntity tile = this.field_70331_k.func_72796_p(x, y, z);
        return tile != null && tile instanceof TilePressureVessel ? (TilePressureVessel)tile : null;
    }

    public boolean tryToAdd(int x, int y, int z) {
        TilePressureVessel neighbour = this.isSameBlock(x, y, z);
        if (neighbour != null) {
            this.master = neighbour.master;
            TilePressureVessel mstr = (TilePressureVessel)this.getMaster();
            mstr.addSlave(new TileMultiBlock.MultiPart(this.field_70329_l, this.field_70330_m, this.field_70327_n));
            return true;
        }
        return false;
    }

    @Override
    public void onBlockPlaced() {
        if (this.tryToAdd(this.field_70329_l + 1, this.field_70330_m, this.field_70327_n)) {
            return;
        }
        if (this.tryToAdd(this.field_70329_l - 1, this.field_70330_m, this.field_70327_n)) {
            return;
        }
        if (this.tryToAdd(this.field_70329_l, this.field_70330_m, this.field_70327_n + 1)) {
            return;
        }
        if (this.tryToAdd(this.field_70329_l, this.field_70330_m, this.field_70327_n - 1)) {
            return;
        }
        if (this.tryToAdd(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) {
            return;
        }
        if (this.tryToAdd(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)) {
            return;
        }
        this.master = new TileMultiBlock.MultiPart(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void onBlockBreak() {
        block3: {
            TileMultiBlock master;
            block4: {
                if (this.getMaster() == null) break block3;
                master = this.getMaster();
                if (!((Object)((Object)master)).equals(this)) break block4;
                if (this.slaves.size() <= 0) break block3;
                TileMultiBlock.MultiPart coords = (TileMultiBlock.MultiPart)this.slaves.get(0);
                this.slaves.remove(0);
                for (TileMultiBlock.MultiPart slave : this.slaves) {
                    TilePressureVessel vessel = (TilePressureVessel)this.field_70331_k.func_72796_p(slave.xCoord, slave.yCoord, slave.zCoord);
                    if (vessel == null) continue;
                    vessel.setMaster(new TileMultiBlock.MultiPart(coords.xCoord, coords.yCoord, coords.zCoord));
                }
                this.master = coords;
                NBTTagCompound contents = new NBTTagCompound();
                this.func_70310_b(contents);
                contents.func_74768_a("x", coords.xCoord);
                contents.func_74768_a("y", coords.yCoord);
                contents.func_74768_a("z", coords.zCoord);
                TilePressureVessel theMaster = (TilePressureVessel)this.field_70331_k.func_72796_p(coords.xCoord, coords.yCoord, coords.zCoord);
                if (theMaster != null) {
                    theMaster.func_70307_a(contents);
                }
                break block3;
            }
            for (TileMultiBlock.MultiPart part : master.getSlaves()) {
                if (part.xCoord != this.field_70329_l || part.yCoord != this.field_70330_m || part.zCoord != this.field_70327_n) continue;
                master.removeSlave(part);
                break;
            }
        }
    }
}

