/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import java.util.List;
import mariculture.core.network.Packet118FluidUpdate;
import mariculture.core.network.Packets;
import mariculture.core.util.ITank;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileHDFPV
extends TileEntity
implements IFluidHandler,
ITank {
    public FluidStack fluid;

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.fluid == null || resource.getFluid() == this.fluid.getFluid()) {
            if (doFill) {
                if (this.fluid == null) {
                    this.fluid = new FluidStack(resource.fluidID, 0);
                }
                this.fluid.amount += resource.amount;
                Packets.updateTile(this, new Packet118FluidUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getFluid()).build());
            }
            return resource.amount;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack ret = null;
        if (this.fluid == null) {
            return ret;
        }
        ret = new FluidStack(this.fluid, Math.max(this.fluid.amount - maxDrain, 0));
        if (doDrain) {
            this.fluid.amount -= ret.amount;
            if (this.fluid.amount <= 0) {
                this.fluid = null;
            }
            Packets.updateTile(this, new Packet118FluidUpdate(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.getFluid()).build());
        }
        return ret;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.fluid.amount < Integer.MAX_VALUE;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return fluid != null;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(this.fluid, Integer.MAX_VALUE)};
    }

    @Override
    public FluidStack getFluid(int transfer) {
        return this.fluid;
    }

    @Override
    public int getTankScaled(int i) {
        return 0;
    }

    @Override
    public FluidStack getFluid() {
        return this.fluid;
    }

    @Override
    public FluidStack getFluid(byte tank) {
        return this.getFluid();
    }

    @Override
    public String getFluidName() {
        return "";
    }

    @Override
    public List getFluidQty(List tooltip) {
        return null;
    }

    @Override
    public void setFluid(FluidStack fluid) {
        this.fluid = fluid;
    }

    @Override
    public void setFluid(FluidStack fluid, byte tank) {
        this.setFluid(fluid);
    }

    public void func_70307_a(NBTTagCompound tagCompound) {
        super.func_70307_a(tagCompound);
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound);
    }

    public void func_70310_b(NBTTagCompound tagCompound) {
        super.func_70310_b(tagCompound);
        if (this.fluid != null) {
            this.fluid.writeToNBT(tagCompound);
        }
    }
}

