/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import java.util.HashMap;
import mariculture.api.fishery.Fishing;
import mariculture.core.blocks.base.TileStorage;
import mariculture.core.gui.ContainerMariculture;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.helpers.cofh.InventoryHelper;
import mariculture.core.network.Packets;
import mariculture.core.util.IEjectable;
import mariculture.core.util.IHasClickableButton;
import mariculture.core.util.IItemDropBlacklist;
import mariculture.core.util.IMachine;
import mariculture.fishery.Fish;
import mariculture.fishery.items.ItemFishy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraftforge.common.ForgeDirection;

public class TileFishSorter
extends TileStorage
implements IItemDropBlacklist,
IMachine,
ISidedInventory,
IEjectable,
IHasClickableButton {
    private int dft_side;
    private HashMap<Integer, Integer> sorting = new HashMap();
    private FeatureEject.EjectSetting setting;
    public static final int input = 21;
    public static final int DFT_SWITCH = 0;

    public TileFishSorter() {
        this.inventory = new ItemStack[22];
        this.setting = FeatureEject.EjectSetting.ITEM;
    }

    public int[] func_94128_d(int side) {
        return new int[]{21};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return slot == 21;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        if (slot < 21) {
            return false;
        }
        int stored = this.getSlotForStack(stack);
        if (stored == -1) {
            return side == this.dft_side;
        }
        if (this.sorting.containsKey(stored)) {
            return this.sorting.get(stored) == side;
        }
        return side == this.dft_side;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = slot == 21 ? this.ejectStack(stack) : stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public ItemStack ejectStack(ItemStack stack) {
        if (FeatureEject.EjectSetting.canEject(this.setting, FeatureEject.EjectSetting.ITEM)) {
            stack = this.ejectToSides(stack);
        }
        return stack;
    }

    private ItemStack ejectToSides(ItemStack stack) {
        int side = 0;
        int stored = this.getSlotForStack(stack);
        side = stored == -1 ? this.dft_side : (this.sorting.containsKey(stored) ? this.sorting.get(stored) : this.dft_side);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        TileEntity tile = this.field_70331_k.func_72796_p(this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ);
        if (tile instanceof IInventory && !(tile instanceof TileEntityHopper)) {
            stack = InventoryHelper.insertItemStackIntoInventory((IInventory)tile, stack, dir.getOpposite().ordinal());
        }
        if (stack != null) {
            SpawnItemHelper.spawnItem(this.field_70331_k, this.field_70329_l + dir.offsetX, this.field_70330_m + dir.offsetY, this.field_70327_n + dir.offsetZ, stack);
        }
        return null;
    }

    public static boolean hasSameFishDNA(ItemStack fish1, ItemStack fish2) {
        if (Fishing.fishHelper.isEgg(fish1)) {
            return Fishing.fishHelper.isEgg(fish2);
        }
        if (Fish.species.getDNA(fish1).equals(Fish.species.getDNA(fish2))) {
            return Fish.species.getLowerDNA(fish1).equals(Fish.species.getLowerDNA(fish2));
        }
        if (Fish.species.getDNA(fish1).equals(Fish.species.getLowerDNA(fish2))) {
            return Fish.species.getLowerDNA(fish1).equals(Fish.species.getDNA(fish2));
        }
        return false;
    }

    public int getSlotForStack(ItemStack stack) {
        if (stack == null) {
            return -1;
        }
        for (int i = 0; i < 21; ++i) {
            ItemStack item;
            if (this.func_70301_a(i) == null || (item = this.func_70301_a(i)) == null || !(item.func_77973_b() instanceof ItemFishy && stack.func_77973_b() instanceof ItemFishy ? TileFishSorter.hasSameFishDNA(item, stack) : OreDicHelper.convert(stack).equals(OreDicHelper.convert(item)))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        switch (id) {
            case 22: {
                this.dft_side = value;
                break;
            }
            case 21: {
                this.setting = FeatureEject.EjectSetting.values()[value];
                break;
            }
            default: {
                this.sorting.put(id, value);
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerMariculture container, EntityPlayer player) {
        for (int i = 0; i < 21; ++i) {
            Packets.updateGUI(player, container, i, this.sorting.containsKey(i) ? this.sorting.get(i) : 0);
        }
        Packets.updateGUI(player, container, 21, this.setting.ordinal());
        Packets.updateGUI(player, container, 22, this.dft_side);
    }

    @Override
    public ItemStack[] getInventory() {
        return this.inventory;
    }

    @Override
    public boolean doesDrop(int slot) {
        return slot == 21;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEM;
    }

    @Override
    public FeatureEject.EjectSetting getEjectSetting() {
        return this.setting != null ? this.setting : FeatureEject.EjectSetting.NONE;
    }

    @Override
    public void setEjectSetting(FeatureEject.EjectSetting setting) {
        this.setting = setting;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.setting = FeatureEject.EjectSetting.readFromNBT(nbt);
        for (int i = 0; i < 21; ++i) {
            this.sorting.put(i, nbt.func_74762_e("SideSettingForSlot" + i));
        }
        this.dft_side = nbt.func_74762_e("DefaultSide");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        FeatureEject.EjectSetting.writeToNBT(nbt, this.setting);
        for (int i = 0; i < 21; ++i) {
            int val = this.sorting.containsKey(i) ? this.sorting.get(i) : 0;
            nbt.func_74768_a("SideSettingForSlot" + i, val);
        }
        nbt.func_74768_a("DefaultSide", this.dft_side);
    }

    public int getSide(int slot) {
        if (this.sorting.containsKey(slot)) {
            return this.sorting.get(slot);
        }
        return 0;
    }

    public void swapSide(int slot) {
        if (this.sorting.containsKey(slot)) {
            int side = this.sorting.get(slot);
            side = side + 1 < 6 ? side + 1 : 0;
            this.sorting.put(slot, side);
        } else {
            this.sorting.put(slot, 1);
        }
    }

    public int getDefaultSide() {
        return this.dft_side;
    }

    @Override
    public void handleButtonClick(int id) {
        if (id == 0) {
            this.dft_side = this.dft_side + 1 < 6 ? this.dft_side + 1 : 0;
        }
    }
}

