/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import mariculture.api.core.MaricultureRegistry;
import mariculture.core.util.IItemRegistry;
import mariculture.factory.Factory;
import mariculture.factory.blocks.BlockCustomHelper;
import mariculture.factory.blocks.TileCustom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStep;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCustomSlab
extends BlockStep
implements IItemRegistry {
    private static int singleSlabID = 0;

    public BlockCustomSlab(int id, boolean isDouble) {
        super(id, isDouble);
        if (!isDouble) {
            singleSlabID = this.field_71990_ca;
        }
        this.func_71848_c(1.5f);
        this.func_71894_b(10.0f);
        this.func_71884_a(field_71976_h);
        this.func_71868_h(0);
        this.func_71849_a(null);
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean isBlockNormalCube(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == Factory.customSlabsDouble.field_71990_ca;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int side, int meta) {
        return Block.field_71981_t.func_71858_a(side, meta);
    }

    protected ItemStack func_71880_c_(int meta) {
        return new ItemStack(singleSlabID, 2, meta & 7);
    }

    public Icon func_71895_b(IBlockAccess block, int x, int y, int z, int side) {
        return BlockCustomHelper.getBlockTexture(block, x, y, z, side);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        super.func_71860_a(world, x, y, z, entity, stack);
        BlockCustomHelper.onBlockPlacedBy(world, x, y, z, entity, stack);
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        return BlockCustomHelper.rotateBlock(world, x, y, z, axis);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        return BlockCustomHelper.getBlockHardness(world, x, y, z);
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        return BlockCustomHelper.getExplosionResistance(entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, World world, int x, int y, int z) {
        return false;
    }

    public int func_71925_a(Random rand) {
        return 0;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        return BlockCustomHelper.removeBlockByPlayer(world, player, x, y, z, this.getID());
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return BlockCustomHelper.getPickBlock(target, world, x, y, z, this.getID());
    }

    private int getID() {
        return 3;
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileCustom();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_71879_a(int id, CreativeTabs tab, List list) {
        list.add(new ItemStack(this.field_71990_ca, 1, 0));
    }

    @Override
    public void register() {
        for (int j = 0; j < this.getMetaCount(); ++j) {
            MaricultureRegistry.register(this.getName(new ItemStack(this.field_71990_ca, 1, j)), new ItemStack(this.field_71990_ca, 1, j));
        }
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public String getName(ItemStack stack) {
        return "customSlab";
    }
}

