/*
 * Decompiled with CFR 0.152.
 */
package mariculture.factory.blocks;

import mariculture.core.lib.PlansMeta;
import mariculture.factory.blocks.TileCustom;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockCustomHelper {
    public static Icon getBlockTexture(IBlockAccess block, int x, int y, int z, int side) {
        TileCustom tile = (TileCustom)block.func_72796_p(x, y, z);
        if (tile != null) {
            try {
                return Block.field_71973_m[tile.theBlockIDs(side)].func_71858_a(tile.theBlockSides(side), tile.theBlockMetas(side));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Block.field_71981_t.func_71858_a(side, 0);
    }

    public static void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        if (stack.func_77942_o()) {
            int[] id = stack.field_77990_d.func_74759_k("BlockIDs");
            int[] meta = stack.field_77990_d.func_74759_k("BlockMetas");
            int[] sides = stack.field_77990_d.func_74759_k("BlockSides");
            String name = stack.field_77990_d.func_74779_i("Name");
            TileCustom tile = (TileCustom)world.func_72796_p(x, y, z);
            if (tile != null) {
                tile.set(id, meta, sides, name);
            }
        }
    }

    public static boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileCustom tile = (TileCustom)world.func_72796_p(x, y, z);
        if (tile != null) {
            if (axis == ForgeDirection.EAST || axis == ForgeDirection.WEST || axis == ForgeDirection.NORTH || axis == ForgeDirection.SOUTH) {
                int[] ids = new int[]{tile.theBlockIDs(0), tile.theBlockIDs(1), tile.theBlockIDs(4), tile.theBlockIDs(5), tile.theBlockIDs(3), tile.theBlockIDs(2)};
                int[] metas = new int[]{tile.theBlockMetas(0), tile.theBlockMetas(1), tile.theBlockMetas(4), tile.theBlockMetas(5), tile.theBlockMetas(3), tile.theBlockMetas(2)};
                int[] sides = new int[]{tile.theBlockSides(0), tile.theBlockSides(1), tile.theBlockSides(4), tile.theBlockSides(5), tile.theBlockSides(3), tile.theBlockSides(2)};
                tile.set(ids, metas, sides, tile.name());
                return true;
            }
            if (axis == ForgeDirection.DOWN || axis == ForgeDirection.UP) {
                int[] ids = new int[]{tile.theBlockIDs(1), tile.theBlockIDs(0), tile.theBlockIDs(2), tile.theBlockIDs(3), tile.theBlockIDs(4), tile.theBlockIDs(5)};
                int[] metas = new int[]{tile.theBlockMetas(1), tile.theBlockMetas(0), tile.theBlockMetas(2), tile.theBlockMetas(3), tile.theBlockMetas(4), tile.theBlockMetas(5)};
                int[] sides = new int[]{tile.theBlockSides(1), tile.theBlockSides(0), tile.theBlockSides(2), tile.theBlockSides(3), tile.theBlockSides(4), tile.theBlockSides(5)};
                tile.set(ids, metas, sides, tile.name());
                return true;
            }
        }
        return false;
    }

    public static float getBlockHardness(World world, int x, int y, int z) {
        TileCustom tile;
        float hardness = 0.0f;
        if (world.func_72796_p(x, y, z) != null && world.func_72796_p(x, y, z) instanceof TileCustom && (tile = (TileCustom)world.func_72796_p(x, y, z)).size() == 6) {
            for (int i = 0; i < 6; ++i) {
                if (Block.field_71973_m[tile.theBlockIDs(i)] == null) continue;
                hardness += Block.field_71973_m[tile.theBlockIDs((int)i)].field_71989_cb;
            }
        }
        return (hardness /= 6.0f) > 0.0f ? hardness : 0.1f;
    }

    public static float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileCustom tile;
        float resistance = 0.0f;
        if (world.func_72796_p(x, y, z) != null && world.func_72796_p(x, y, z) instanceof TileCustom && (tile = (TileCustom)world.func_72796_p(x, y, z)).size() == 6) {
            for (int i = 0; i < 6; ++i) {
                if (Block.field_71973_m[tile.theBlockIDs(i)] == null) continue;
                resistance += Block.field_71973_m[tile.theBlockIDs((int)i)].field_72029_cc / 3.0f;
            }
        }
        return (resistance /= 6.0f) > 0.0f ? resistance : 0.1f;
    }

    public static boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z, int plan) {
        if (!player.field_71075_bZ.field_75098_d) {
            TileCustom tile = (TileCustom)world.func_72796_p(x, y, z);
            ItemStack drop = PlansMeta.getBlockStack(plan);
            if (!drop.func_77942_o()) {
                drop.func_77982_d(new NBTTagCompound());
            }
            if (tile != null) {
                drop.field_77990_d.func_74783_a("BlockIDs", tile.theBlockIDs());
                drop.field_77990_d.func_74783_a("BlockMetas", tile.theBlockMetas());
                drop.field_77990_d.func_74783_a("BlockSides", tile.theBlockSides());
                drop.field_77990_d.func_74778_a("Name", tile.name());
            }
            BlockCustomHelper.dropBlock(world, x, y, z, drop);
        }
        return world.func_94571_i(x, y, z);
    }

    private static void dropBlock(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_70293_c = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    public static ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, int plan) {
        TileCustom tile = (TileCustom)world.func_72796_p(x, y, z);
        ItemStack drop = PlansMeta.getBlockStack(plan);
        if (!drop.func_77942_o()) {
            drop.func_77982_d(new NBTTagCompound());
        }
        if (tile != null) {
            drop.field_77990_d.func_74783_a("BlockIDs", tile.theBlockIDs());
            drop.field_77990_d.func_74783_a("BlockMetas", tile.theBlockMetas());
            drop.field_77990_d.func_74783_a("BlockSides", tile.theBlockSides());
            drop.field_77990_d.func_74778_a("Name", tile.name());
        }
        return drop;
    }
}

