/*
 * Decompiled with CFR 0.152.
 */
package mariculture.diving;

import mariculture.core.Core;
import mariculture.core.helpers.PlayerHelper;
import mariculture.core.lib.ArmorSlot;
import mariculture.core.lib.Extra;
import mariculture.diving.Diving;
import mariculture.diving.DivingBoots;
import mariculture.diving.HardcoreDiving;
import mariculture.diving.ScubaFin;
import mariculture.diving.ScubaMask;
import mariculture.diving.ScubaTank;
import mariculture.diving.Snorkel;
import mariculture.diving.UnderwaterVision;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class ArmorEventHandler {
    private UnderwaterVision vision;

    @ForgeSubscribe
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entity;
            if (!player.field_70170_p.field_72995_K) {
                ScubaTank.init(player);
                ScubaMask.damage(player);
                if (Extra.HARDCORE_DIVING > 0) {
                    HardcoreDiving.init(player);
                }
                Snorkel.init(player);
            } else {
                this.vision = this.vision == null ? new UnderwaterVision() : this.vision.onUpdate(player);
                DivingBoots.init(player);
                ScubaFin.init(player);
            }
        }
    }

    @ForgeSubscribe
    public void onBreaking(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        boolean isValid = false;
        if (ForgeHooks.canHarvestBlock((Block)event.block, (EntityPlayer)player, (int)event.metadata) && player.func_70055_a(Material.field_76244_g)) {
            if (PlayerHelper.hasArmor(player, ArmorSlot.LEG, Diving.scubaSuit)) {
                event.newSpeed = event.originalSpeed * 4.0f;
                if (event.block.field_71990_ca == Core.oyster.field_71990_ca) {
                    event.newSpeed = event.originalSpeed * 128.0f;
                }
            }
            if (PlayerHelper.hasArmor(player, ArmorSlot.FEET, Diving.swimfin) && !player.field_70122_E) {
                event.newSpeed *= 5.0f;
            }
            if (PlayerHelper.hasArmor(player, ArmorSlot.LEG, Diving.divingPants)) {
                event.newSpeed = event.originalSpeed * 2.0f;
                if (event.block.field_71990_ca == Core.oyster.field_71990_ca) {
                    event.newSpeed = event.originalSpeed * 64.0f;
                }
            }
        }
    }
}

