/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import mariculture.core.Core;
import mariculture.core.blocks.BlockOyster;
import mariculture.core.blocks.TileAirPump;
import mariculture.core.blocks.TileAnvil;
import mariculture.core.blocks.TileBlockCaster;
import mariculture.core.blocks.TileIngotCaster;
import mariculture.core.blocks.TileOyster;
import mariculture.core.lib.RenderIds;
import mariculture.core.render.RenderAnvil;
import mariculture.core.render.RenderBlockCaster;
import mariculture.core.render.RenderIngotCaster;
import mariculture.core.render.RenderOyster;
import mariculture.diving.render.ModelAirPump;
import mariculture.factory.blocks.TileFLUDDStand;
import mariculture.factory.blocks.TileGeyser;
import mariculture.factory.blocks.TileTurbineGas;
import mariculture.factory.blocks.TileTurbineHand;
import mariculture.factory.blocks.TileTurbineWater;
import mariculture.factory.render.ModelFLUDD;
import mariculture.factory.render.ModelTurbineGas;
import mariculture.factory.render.ModelTurbineHand;
import mariculture.factory.render.ModelTurbineWater;
import mariculture.factory.render.RenderGeyser;
import mariculture.fishery.blocks.TileFeeder;
import mariculture.fishery.blocks.TileSift;
import mariculture.fishery.render.ModelFeeder;
import mariculture.fishery.render.ModelSift;
import mariculture.fishery.render.RenderNet;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;

public class RenderSingle
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    private ModelBase model;
    private ResourceLocation resource;

    public RenderSingle() {
    }

    public RenderSingle(ModelBase model, ResourceLocation resource) {
        this.model = model;
        this.resource = resource;
    }

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float tick) {
        if (tileEntity instanceof TileAirPump) {
            this.func_110628_a(this.resource);
            ((ModelAirPump)this.model).render((TileAirPump)tileEntity, x, y, z);
        }
        if (tileEntity instanceof TileSift) {
            this.func_110628_a(this.resource);
            ((ModelSift)this.model).render((TileSift)tileEntity, x, y, z);
        }
        if (tileEntity instanceof TileFeeder) {
            this.func_110628_a(this.resource);
            ((ModelFeeder)this.model).render((TileFeeder)tileEntity, x, y, z);
        }
        if (tileEntity instanceof TileTurbineWater) {
            this.func_110628_a(this.resource);
            ((ModelTurbineWater)this.model).render((TileTurbineWater)tileEntity, x, y, z);
        }
        if (tileEntity instanceof TileTurbineGas) {
            this.func_110628_a(this.resource);
            ((ModelTurbineGas)this.model).render((TileTurbineGas)tileEntity, x, y, z);
        }
        if (tileEntity instanceof TileTurbineHand) {
            this.func_110628_a(this.resource);
            ((ModelTurbineHand)this.model).render((TileTurbineHand)tileEntity, x, y, z);
        }
        if (tileEntity instanceof TileFLUDDStand) {
            this.func_110628_a(this.resource);
            ((ModelFLUDD)this.model).render((TileFLUDDStand)tileEntity, x, y, z);
        }
    }

    public void renderInventoryBlock(Block block, int meta, int modelID, RenderBlocks render) {
        if (block.field_71990_ca == Core.rendered.field_71990_ca) {
            if (meta == 7) {
                new RenderAnvil(render).render();
            }
            if (meta == 11) {
                new RenderIngotCaster(render).render();
            }
            if (meta == 13) {
                new RenderBlockCaster(render).render();
            }
            if (meta == 2) {
                new RenderGeyser(render).render();
            }
        } else if (block.field_71990_ca == Core.oyster.field_71990_ca && meta < BlockOyster.NET) {
            new RenderOyster(render).render();
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks render) {
        TileEntity tile = world.func_72796_p(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (tile instanceof TileGeyser) {
            return new RenderGeyser(render).setCoords(world, x, y, z).setDir(((TileGeyser)tile).orientation).render();
        }
        if (tile instanceof TileIngotCaster) {
            return new RenderIngotCaster(render).setCoords(world, x, y, z).render();
        }
        if (tile instanceof TileBlockCaster) {
            return new RenderBlockCaster(render).setCoords(world, x, y, z).render();
        }
        if (world.func_72798_a(x, y, z) == Core.oyster.field_71990_ca && meta == BlockOyster.NET) {
            return new RenderNet(render).setCoords(world, x, y, z).render();
        }
        if (tile instanceof TileAnvil) {
            ForgeDirection facing = meta - 7 == 3 ? ForgeDirection.SOUTH : (meta - 7 == 2 ? ForgeDirection.WEST : (meta - 7 == 1 ? ForgeDirection.NORTH : ForgeDirection.EAST));
            return new RenderAnvil(render).setCoords(world, x, y, z).setDir(facing).render();
        }
        if (tile instanceof TileOyster) {
            ForgeDirection facing = meta == 3 ? ForgeDirection.SOUTH : (meta == 2 ? ForgeDirection.WEST : (meta == 1 ? ForgeDirection.NORTH : ForgeDirection.EAST));
            return new RenderOyster(render).setCoords(world, x, y, z).setDir(facing).render();
        }
        return false;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return RenderIds.BLOCK_SINGLE;
    }
}

