/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.render;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import mariculture.core.blocks.TileVat;
import mariculture.core.lib.RenderIds;
import mariculture.core.render.RenderVat;
import mariculture.diving.TileAirCompressor;
import mariculture.diving.render.RenderCompressorBase;
import mariculture.diving.render.RenderCompressorTop;
import mariculture.factory.blocks.TilePressureVessel;
import mariculture.factory.render.RenderPressureVessel;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class RenderDouble
implements ISimpleBlockRenderingHandler {
    public void renderInventoryBlock(Block block, int meta, int modelID, RenderBlocks render) {
        if (meta == 3) {
            new RenderVat(render).render();
        } else if (meta == 0) {
            new RenderCompressorBase(render).render();
        } else if (meta == 1) {
            new RenderCompressorTop(render).render();
        } else if (meta == 2) {
            new RenderPressureVessel(render).render();
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks render) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TilePressureVessel) {
            return new RenderPressureVessel(render).setCoords(world, x, y, z).render();
        }
        if (tile instanceof TileVat) {
            return new RenderVat(render).setCoords(world, x, y, z).setDir(((TileVat)tile).facing).render();
        }
        if (tile instanceof TileAirCompressor) {
            if (world.func_72805_g(x, y, z) == 0) {
                return new RenderCompressorBase(render).setCoords(world, x, y, z).setDir(((TileAirCompressor)tile).facing).render();
            }
            return new RenderCompressorTop(render).setCoords(world, x, y, z).setDir(((TileAirCompressor)tile).facing).render();
        }
        return false;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return RenderIds.BLOCK_DOUBLE;
    }
}

