/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.render;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public abstract class RenderBase {
    public static HashMap<String, RenderBase> renderers = new HashMap();
    static final double RENDER_OFFSET = (double)0.001f;
    static final float LIGHT_Y_NEG = 0.5f;
    static final float LIGHT_Y_POS = 1.0f;
    static final float LIGHT_XZ_NEG = 0.8f;
    static final float LIGHT_XZ_POS = 0.6f;
    public RenderBlocks render;
    public ForgeDirection dir = ForgeDirection.UNKNOWN;
    public IBlockAccess world;
    public int x;
    public int y;
    public int z;
    public Icon icon;
    public Block block;

    public RenderBase(RenderBlocks render) {
        this.render = render;
    }

    public RenderBase setCoords(IBlockAccess world, int x, int y, int z) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.block = Block.field_71973_m[world.func_72798_a(x, y, z)];
        return this;
    }

    public RenderBase setDir(ForgeDirection dir) {
        this.dir = dir;
        return this;
    }

    public RenderBase setBlock(Block block) {
        this.block = block;
        return this;
    }

    public boolean render() {
        if (this.isItem()) {
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)-0.5f, (float)-0.4f, (float)-0.5f);
            GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
            this.renderBlock();
            GL11.glPopMatrix();
        } else {
            this.renderBlock();
            if (this.render.func_94167_b()) {
                this.render.func_78595_a();
            }
        }
        return true;
    }

    public abstract void renderBlock();

    public boolean isItem() {
        return this.world == null;
    }

    protected void setTexture(Icon texture) {
        if (this.isItem()) {
            this.icon = texture;
        } else {
            this.icon = texture;
            this.render.func_82774_a(texture);
        }
    }

    protected void setTexture(Block block, int meta) {
        this.setTexture(block.func_71858_a(0, meta));
    }

    protected void setTexture(Block block) {
        this.setTexture(block, 0);
    }

    protected void renderBlock(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (this.isItem()) {
            this.renderItemBlock(minX, minY, minZ, maxX, maxY, maxZ);
        } else {
            this.renderWorldBlock(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }

    protected void renderFace(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3, double x4, double y4, double z4) {
        Tessellator tessellator = Tessellator.field_78398_a;
        Icon iicon = this.icon;
        if (!this.isItem()) {
            tessellator.func_78380_c(this.block.func_71874_e(this.world, this.x, this.y, this.z));
        }
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        double d0 = iicon.func_94209_e();
        double d1 = iicon.func_94206_g();
        double d2 = iicon.func_94212_f();
        double d3 = iicon.func_94210_h();
        double d4 = 0.0625;
        double d5 = (double)(this.x + 1) + x1;
        double d6 = (double)(this.x + 1) + x2;
        double d7 = (double)(this.x + 0) + x3;
        double d8 = (double)(this.x + 0) + x4;
        double d9 = (double)(this.z + 0) + z1;
        double d10 = (double)(this.z + 1) + z2;
        double d11 = (double)(this.z + 1) + z3;
        double d12 = (double)(this.z + 0) + z4;
        double d13 = (double)this.y + d4 + y1;
        double d14 = (double)this.y + d4 + y2;
        double d15 = (double)this.y + d4 + y3;
        double d16 = (double)this.y + d4 + y4;
        tessellator.func_78374_a(d5, d13, d9, d2, d1);
        tessellator.func_78374_a(d6, d14, d10, d2, d3);
        tessellator.func_78374_a(d7, d15, d11, d0, d3);
        tessellator.func_78374_a(d8, d16, d12, d0, d1);
        tessellator.func_78374_a(d8, d16, d12, d0, d1);
        tessellator.func_78374_a(d7, d15, d11, d0, d3);
        tessellator.func_78374_a(d6, d14, d10, d2, d3);
        tessellator.func_78374_a(d5, d13, d9, d2, d1);
    }

    protected void renderAngledBlock(double x2, double y2, double z2, double x3, double y3, double z3, double x1, double y1, double z1, double x4, double y4, double z4, double xDim, double height, double zDim) {
        this.renderFace(x1, y1, z1, x2, y2, z2, x3, y3, z3, x4, y4, z4);
        this.renderFace(x1, y1 + height, z1, x2, y2 + height, z2, x3, y3 + height, z3, x4, y4 + height, z4);
        this.renderFace(x1, y1, z1, x2, y2, z2, x2 + 1.0, y2 + height, z2, x1 + 1.0, y1 + height, z1);
        this.renderFace(x4 - 1.0, y4, z4, x3 - 1.0, y3, z3, x3, y3 + height, z3, x4, y4 + height, z4);
        this.renderFace(x1, y1, z1, x1, y1 + height, z1 - 1.0, x4, y4 + height, z4 - 1.0, x4, y4, z4);
        this.renderFace(x2, y2, z2 + 1.0, x2, y2 + height, z2, x3, y3 + height, z3, x3, y3, z3 + 1.0);
    }

    protected void renderFluid(FluidStack fluid, int max, double scale, int xPlus, int yPlus, int zPlus) {
        int x2 = this.x + xPlus;
        int y2 = this.y + yPlus;
        int z2 = this.z + zPlus;
        Tessellator tessellator = Tessellator.field_78398_a;
        int color = this.block.func_71920_b(this.world, x2, y2, z2);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        double extra = (double)fluid.amount / (double)max * scale;
        double height = 0.4 + extra;
        Icon iconStill = fluid.getFluid().getIcon();
        height += (double)0.001f;
        double u2 = iconStill.func_94214_a(0.0);
        double v2 = iconStill.func_94207_b(0.0);
        double u1 = u2;
        double v1 = iconStill.func_94207_b(16.0);
        double u4 = iconStill.func_94214_a(16.0);
        double v4 = v1;
        double u3 = u4;
        double v3 = v2;
        tessellator.func_78380_c(200);
        tessellator.func_78386_a(1.0f * red, 1.0f * green, 1.0f * blue);
        tessellator.func_78374_a((double)(x2 + 0), (double)y2 + height, (double)(z2 + 0), u2, v2);
        tessellator.func_78374_a((double)(x2 + 0), (double)y2 + height, (double)(z2 + 1), u1, v1);
        tessellator.func_78374_a((double)(x2 + 1), (double)y2 + height, (double)(z2 + 1), u4, v4);
        tessellator.func_78374_a((double)(x2 + 1), (double)y2 + height, (double)(z2 + 0), u3, v3);
        this.render.field_83027_i = 0.0;
        this.render.field_83024_j = 1.0;
    }

    protected void renderFluidBlock(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.render.field_78661_f = true;
        this.render.func_83020_a(minX, minY, minZ, maxX, maxY, maxZ);
        this.render.func_78570_q(Block.field_71938_D, this.x, this.y, this.z);
        this.render.field_78661_f = false;
    }

    private void renderWorldBlock(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.render.field_78661_f = true;
        this.render.func_83020_a(minX, minY, minZ, maxX, maxY, maxZ);
        this.render.func_78570_q(this.block, this.x, this.y, this.z);
        this.render.field_78661_f = false;
    }

    private void renderItemBlock(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.render.field_83021_g = minX;
        this.render.field_83027_i = minY;
        this.render.field_83025_k = minZ;
        this.render.field_83026_h = maxX;
        this.render.field_83024_j = maxY;
        this.render.field_83022_l = maxZ;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        this.render.func_78613_a(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        this.render.func_78617_b(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        this.render.func_78611_c(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        this.render.func_78622_d(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        this.render.func_78573_e(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        this.render.func_78605_f(this.block, 0.0, 0.0, 0.0, this.icon);
        tessellator.func_78381_a();
    }
}

