/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mariculture.core.network.PacketMariculture;
import mariculture.core.util.ITank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class Packet118FluidUpdate
extends PacketMariculture {
    private int id;
    private int vol;
    private int x;
    private int y;
    private int z;
    private byte num;

    public Packet118FluidUpdate() {
    }

    public Packet118FluidUpdate(int x, int y, int z, FluidStack fluid) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (fluid == null) {
            this.id = 0;
            this.vol = 0;
        } else {
            this.id = fluid.fluidID;
            this.vol = fluid.amount;
        }
        this.num = 0;
    }

    public Packet118FluidUpdate(int x, int y, int z, FluidStack fluid, byte tank) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (fluid == null) {
            this.id = 0;
            this.vol = 0;
        } else {
            this.id = fluid.fluidID;
            this.vol = fluid.amount;
        }
        this.num = tank;
    }

    @Override
    public void handle(World world, EntityPlayer player) {
        TileEntity te = world.func_72796_p(this.x, this.y, this.z);
        if (te instanceof ITank) {
            FluidStack fluid = this.vol == 0 || this.id == 0 ? null : new FluidStack(this.id, this.vol);
            ((ITank)te).setFluid(fluid, this.num);
        }
        world.func_72902_n(this.x, this.y, this.z);
    }

    @Override
    public void read(DataInputStream is) throws IOException {
        this.x = is.readInt();
        this.y = is.readInt();
        this.z = is.readInt();
        this.id = is.readInt();
        this.vol = is.readInt();
        this.num = is.readByte();
    }

    @Override
    public void write(DataOutputStream os) throws IOException {
        os.writeInt(this.x);
        os.writeInt(this.y);
        os.writeInt(this.z);
        os.writeInt(this.id);
        os.writeInt(this.vol);
        os.writeByte(this.num);
    }
}

