/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.network;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mariculture.core.network.PacketMariculture;
import mariculture.factory.blocks.TileSponge;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class Packet101Sponge
extends PacketMariculture {
    public int x;
    public int y;
    public int z;
    public int stored;
    public int max;
    boolean isClient;

    public Packet101Sponge() {
    }

    public Packet101Sponge(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.isClient = false;
    }

    public Packet101Sponge(int stored, int max) {
        this.stored = stored;
        this.max = max;
        this.isClient = true;
    }

    @Override
    public void handle(World world, EntityPlayer player) {
        if (this.isClient) {
            FMLClientHandler.instance().getClient().field_71456_v.func_73827_b().func_73765_a(this.stored + " / " + this.max + " RF");
        } else if (world.func_72796_p(this.x, this.y, this.z) instanceof TileSponge) {
            TileSponge sponge = (TileSponge)world.func_72796_p(this.x, this.y, this.z);
            this.stored = sponge.getEnergyStored(ForgeDirection.UNKNOWN);
            this.max = sponge.getMaxEnergyStored(ForgeDirection.UNKNOWN);
            PacketDispatcher.sendPacketToPlayer((Packet)new Packet101Sponge(this.stored, this.max).build(), (Player)((Player)player));
        }
    }

    @Override
    public void read(DataInputStream is) throws IOException {
        this.isClient = is.readBoolean();
        if (!this.isClient) {
            this.x = is.readInt();
            this.y = is.readInt();
            this.z = is.readInt();
        } else {
            this.stored = is.readInt();
            this.max = is.readInt();
        }
    }

    @Override
    public void write(DataOutputStream os) throws IOException {
        if (!this.isClient) {
            os.writeBoolean(this.isClient);
            os.writeInt(this.x);
            os.writeInt(this.y);
            os.writeInt(this.z);
        } else {
            os.writeBoolean(this.isClient);
            os.writeInt(this.max);
            os.writeInt(this.stored);
        }
    }
}

