/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import mariculture.Mariculture;
import mariculture.api.core.MaricultureRegistry;
import mariculture.api.core.MaricultureTab;
import mariculture.core.gui.ContainerStorage;
import mariculture.core.gui.GuiStorage;
import mariculture.core.gui.InventoryStorage;
import mariculture.core.gui.feature.Feature;
import mariculture.core.handlers.LogHandler;
import mariculture.core.util.IItemRegistry;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class ItemStorage
extends Item
implements IItemRegistry {
    public int size;
    public String gui;

    public ItemStorage(int i, int storage, String gui) {
        super(i);
        this.field_77777_bU = 1;
        this.size = storage;
        this.gui = gui;
        this.func_77637_a(MaricultureTab.tabMariculture);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack != null) {
            if (!player.func_70093_af()) {
                player.openGui((Object)Mariculture.instance, 16, world, 0, 0, 0);
            }
            return stack;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack(this.field_77779_bT, 1, 0)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int j, CreativeTabs creative, List list) {
        list.add(new ItemStack(j, 1, 0));
    }

    @Override
    public void register() {
        MaricultureRegistry.register(this.getName(new ItemStack(this.field_77779_bT, 1, 0)), new ItemStack(this.field_77779_bT, 1, 0));
    }

    @Override
    public int getMetaCount() {
        return 1;
    }

    @Override
    public String getName(ItemStack stack) {
        return this.func_77658_a().substring(5);
    }

    public Slot getSlot(InventoryStorage storage, int i) {
        switch (i) {
            case 0: {
                return new Slot((IInventory)storage, i, 43, 25);
            }
        }
        return new Slot((IInventory)storage, i, 100, 100);
    }

    public int getX(ItemStack stack) {
        return 66;
    }

    public boolean isItemValid(ItemStack stack) {
        return true;
    }

    public ItemStack[] load(EntityPlayer player, ItemStack stack, int size) {
        NBTTagCompound loader = stack.func_77942_o() ? stack.field_77990_d : new NBTTagCompound();
        NBTTagList nbttaglist = loader.func_74761_m("Inventory");
        if (nbttaglist != null) {
            ItemStack[] inventory = new ItemStack[size];
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
                byte byte0 = nbttagcompound1.func_74771_c("Slot");
                if (byte0 < 0 || byte0 >= inventory.length) continue;
                inventory[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
            }
            return inventory;
        }
        return new ItemStack[size];
    }

    public void save(EntityPlayer player, ItemStack[] inventory) {
        try {
            NBTTagList nbttaglist = new NBTTagList();
            for (int i = 0; i < inventory.length; ++i) {
                if (inventory[i] == null) continue;
                NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                nbttagcompound1.func_74774_a("Slot", (byte)i);
                inventory[i].func_77955_b(nbttagcompound1);
                nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
            }
            if (!player.func_71045_bC().func_77942_o()) {
                player.func_71045_bC().func_77982_d(new NBTTagCompound());
            }
            player.func_71045_bC().field_77990_d.func_74782_a("Inventory", (NBTBase)nbttaglist);
        }
        catch (Exception e) {
            LogHandler.log(Level.WARNING, "Mariculture had trouble saving an inventory");
        }
    }

    public void addFeatures(ArrayList<Feature> list) {
    }

    public Object getGUIContainer(EntityPlayer player) {
        return new ContainerStorage((IInventory)player.field_71071_by, new InventoryStorage(player, this.size), player.field_70170_p, 0);
    }

    public Object getGUIElement(EntityPlayer player) {
        return new GuiStorage((IInventory)player.field_71071_by, new InventoryStorage(player, this.size), player.field_70170_p, this.gui, 0);
    }
}

