/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import java.util.logging.Level;
import mariculture.core.handlers.LogHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class StackHelper {
    public static ItemStack getStackFromString(String str) {
        return StackHelper.getStackFromArray(str.trim().split(" "));
    }

    public static String getStringFromStack(ItemStack stack) {
        String str = stack.func_77977_a().substring(5);
        if (stack.func_77981_g()) {
            str = str + " " + stack.func_77960_j();
        }
        if (stack.func_77942_o()) {
            str = str + " " + stack.field_77990_d.toString();
        }
        return str;
    }

    public static boolean matches(String str, ItemStack stack) {
        return StackHelper.getStringFromStack(stack).equals(str);
    }

    private static ItemStack getStackFromArray(String[] str) {
        Item item = StackHelper.getItemByText(str[0]);
        int meta = 0;
        if (str.length > 1) {
            meta = StackHelper.parseInt(str[1]);
        }
        return item == null ? null : new ItemStack(item, 1, meta);
    }

    private static Item getItemByText(String str) {
        try {
            Item item = Item.field_77698_e[Integer.parseInt(str)];
            return Item.field_77698_e[Integer.parseInt(str)];
        }
        catch (NumberFormatException numberformatexception) {
            for (Item item : Item.field_77698_e) {
                if (item == null) continue;
                try {
                    String text = item.func_77658_a();
                    if (text.length() <= 5 || !text.substring(5).equals(str)) continue;
                    return item;
                }
                catch (Exception e) {
                    LogHandler.log(Level.SEVERE, "A Mod has incorrectly registered an item block, go and complain to the author about this!");
                    LogHandler.log(Level.SEVERE, item.toString());
                    LogHandler.log(Level.SEVERE, "ID: " + item.field_77779_bT);
                }
            }
            return null;
        }
    }

    private static int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException numberformatexception) {
            return 0;
        }
    }
}

