/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import mariculture.api.core.FuelInfo;
import mariculture.api.core.IAnvilHandler;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeCasting;
import mariculture.api.core.RecipeSmelter;
import mariculture.api.core.RecipeVat;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.Loot;
import mariculture.api.fishery.RodQuality;
import mariculture.core.Core;
import mariculture.core.lib.MetalRates;
import mariculture.core.lib.Modules;
import mariculture.core.util.FluidDictionary;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeHelper {
    public static ItemStack addUpgrade(int meta, Object[] input) {
        ItemStack result = new ItemStack(Core.upgrade, 1, meta);
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(result, input));
        return result;
    }

    public static void addShapedRecipe(ItemStack result, Object[] input) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(result, input));
    }

    public static void addShapelessRecipe(ItemStack result, Object[] input) {
        CraftingManager.func_77594_a().func_77592_b().add(new ShapelessOreRecipe(result, input));
    }

    public static void addSmelting(int id, int meta, ItemStack stack, float xp) {
        FurnaceRecipes.func_77602_a().addSmelting(id, meta, stack, xp);
    }

    public static void addVatItemRecipe(ItemStack input, String fluid, int vol, ItemStack output, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(input, FluidRegistry.getFluidStack((String)fluid, (int)vol), output, time));
    }

    public static void addVatItemRecipeResultFluid(ItemStack input, FluidStack inputFluid, FluidStack output, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(input, inputFluid, output, time));
    }

    public static void addNuggetCasting(FluidStack fluid, ItemStack stack) {
        MaricultureHandlers.casting.addRecipe(new RecipeCasting.RecipeNuggetCasting(fluid, stack));
    }

    public static void addIngotCasting(FluidStack fluid, ItemStack stack) {
        MaricultureHandlers.casting.addRecipe(new RecipeCasting.RecipeIngotCasting(fluid, stack));
    }

    public static void addBlockCasting(FluidStack fluid, ItemStack stack) {
        MaricultureHandlers.casting.addRecipe(new RecipeCasting.RecipeBlockCasting(fluid, stack));
    }

    public static void addMetalCasting(String fluid, String metal) {
        String nugget = "nugget" + metal;
        String ingot = "ingot" + metal;
        String block = "block" + metal;
        if (OreDictionary.getOres((String)nugget).size() > 0) {
            RecipeHelper.addNuggetCasting(FluidDictionary.getFluidStack(fluid, MetalRates.NUGGET), (ItemStack)OreDictionary.getOres((String)nugget).get(0));
        }
        if (OreDictionary.getOres((String)ingot).size() > 0) {
            RecipeHelper.addIngotCasting(FluidDictionary.getFluidStack(fluid, MetalRates.INGOT), (ItemStack)OreDictionary.getOres((String)ingot).get(0));
        }
        if (OreDictionary.getOres((String)block).size() > 0) {
            RecipeHelper.addBlockCasting(FluidDictionary.getFluidStack(fluid, MetalRates.BLOCK), (ItemStack)OreDictionary.getOres((String)block).get(0));
        }
    }

    public static void addFluidAlloy(FluidStack fluid1, FluidStack fluid2, FluidStack result, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(fluid1, fluid2, result, time));
    }

    public static void addFluidAlloyResultItem(FluidStack fluid1, FluidStack fluid2, ItemStack result, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(fluid1, fluid2, result, time));
    }

    public static void addFluidAlloyResultItemNFluid(FluidStack fluid1, FluidStack fluid2, FluidStack newFluid, ItemStack result, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(fluid1, fluid2, newFluid, result, time));
    }

    public static void addFluidAlloyNItemResultItem(FluidStack fluid1, FluidStack fluid2, ItemStack input, ItemStack result, int time) {
        MaricultureHandlers.vat.addRecipe(new RecipeVat(input, fluid1, fluid2, result, time));
    }

    public static void add4x4Recipe(ItemStack result, Block block, int meta) {
        RecipeHelper.addShapedRecipe(result, new Object[]{"##", "##", Character.valueOf('#'), new ItemStack(block, 1, meta)});
    }

    public static void add2x2Recipe(ItemStack result, Object input) {
        RecipeHelper.addShapedRecipe(result, new Object[]{"##", "##", Character.valueOf('#'), input});
    }

    public static void add3x3Recipe(ItemStack result, Object input) {
        RecipeHelper.addShapedRecipe(result, new Object[]{"###", "###", "###", Character.valueOf('#'), input});
    }

    public static void addUncraftingRecipe(ItemStack result, Object input) {
        RecipeHelper.addShapelessRecipe(result, new Object[]{input});
    }

    public static void addAnvilRecipe(ItemStack input, ItemStack output, int hits) {
        MaricultureHandlers.anvil.addRecipe(new IAnvilHandler.RecipeAnvil(input, output, hits));
    }

    public static void addFishingRodRecipe(ItemStack output, Object mat) {
        RecipeHelper.addShapedRecipe(output, new Object[]{"  S", " SW", "S W", Character.valueOf('S'), mat, Character.valueOf('W'), Item.field_77683_K});
    }

    public static void addMelting(ItemStack stack, int temp, FluidStack fluid) {
        MaricultureHandlers.smelter.addRecipe(new RecipeSmelter(stack, null, temp, fluid, null, 0));
    }

    public static void addMelting(ItemStack stack, int temp, FluidStack fluid, ItemStack output, int chance) {
        MaricultureHandlers.smelter.addRecipe(new RecipeSmelter(stack, null, temp, fluid, output, chance));
    }

    public static void addMelting(ItemStack stack, int temp, String fluid, int vol) {
        RecipeHelper.addMelting(stack, temp, FluidRegistry.getFluidStack((String)fluid, (int)vol));
    }

    public static void addCrossHatchRecipe(ItemStack output, Object item1, Object item2) {
        RecipeHelper.addShapedRecipe(output, new Object[]{"CAC", "ACA", "CAC", Character.valueOf('C'), item1, Character.valueOf('A'), item2});
    }

    public static void addWheelRecipe(ItemStack output, Object wheel, Object spoke) {
        RecipeHelper.addShapedRecipe(output, new Object[]{" W ", "WSW", " W ", Character.valueOf('W'), wheel, Character.valueOf('S'), spoke});
    }

    public static void addFuel(Object obj, FuelInfo fuelInfo) {
        MaricultureHandlers.smelter.addFuel(obj, fuelInfo);
    }

    public static void addMeltingAlloy(ItemStack stack1, ItemStack stack2, int temp, FluidStack fluid) {
        MaricultureHandlers.smelter.addRecipe(new RecipeSmelter(stack1, stack2, temp, fluid, null, 0));
    }

    public static void addCrushRecipe(ItemStack stack, Object string, boolean needAnvil) {
        if (!needAnvil) {
            RecipeHelper.addShapelessRecipe(stack, new Object[]{string});
        }
        ItemStack result = null;
        if (string instanceof String && OreDictionary.getOres((String)((String)string)).size() > 0) {
            result = (ItemStack)OreDictionary.getOres((String)((String)string)).get(0);
        }
        if (string instanceof ItemStack) {
            result = (ItemStack)string;
        }
        if (result != null) {
            if (!needAnvil) {
                stack.field_77994_a *= 2;
            }
            RecipeHelper.addAnvilRecipe(result, stack, 10);
        }
    }

    public static void addBleachRecipe(ItemStack input, ItemStack output, int time) {
        RecipeHelper.addVatItemRecipe(input, FluidDictionary.quicklime, 50, output, time);
    }

    public static void addBookRecipe(ItemStack output, ItemStack input) {
        RecipeHelper.addShapelessRecipe(output, new Object[]{input, Item.field_77760_aL});
    }

    public static void addFishMelting(ItemStack stack, double volume, ItemStack product, int chance) {
        RecipeHelper.addMelting(stack, 180, FluidRegistry.getFluidStack((String)FluidDictionary.fish_oil, (int)((int)(volume * 1000.0))), product, chance);
    }

    public static void addFishSushi(ItemStack raw, int meal) {
        ItemStack kelp = Modules.isActive(Modules.worldplus) ? new ItemStack(Core.food, 1, 8) : new ItemStack(Item.field_77756_aW, 1, 2);
        RecipeHelper.addShapedRecipe(new ItemStack(Core.food, (int)Math.ceil((double)meal / 1.5), 5), new Object[]{" K ", "KFK", " K ", Character.valueOf('K'), kelp, Character.valueOf('F'), raw});
    }

    public static void addFishSoup(ItemStack raw, int meal) {
        ItemStack kelp = Modules.isActive(Modules.worldplus) ? new ItemStack(Core.food, 1, 8) : new ItemStack(Item.field_77756_aW, 1, 2);
        int number = (int)Math.ceil(meal / 2);
        int meta = number == 2 ? 11 : (number >= 3 ? 12 : 7);
        RecipeHelper.addShapelessRecipe(new ItemStack(Core.food, 1, meta), new Object[]{Item.field_77670_E, kelp, raw, Block.field_72109_af, Block.field_72103_ag});
    }

    public static void addFishMeal(ItemStack raw, int meal) {
        RecipeHelper.addShapelessRecipe(new ItemStack(Core.materials, meal, 14), new Object[]{raw});
    }

    public static void addEndLoot(Item item, RodQuality quality, Loot.Rarity type, int rarity) {
        RecipeHelper.addEndLoot(new ItemStack(item), quality, type, rarity);
    }

    public static void addEndLoot(ItemStack stack, RodQuality quality, Loot.Rarity type, int rarity) {
        RecipeHelper.addLoot(stack, quality, type, rarity, 1);
    }

    public static void addNetherLoot(Item item, RodQuality quality, Loot.Rarity type, int rarity) {
        RecipeHelper.addNetherLoot(new ItemStack(item), quality, type, rarity);
    }

    public static void addNetherLoot(ItemStack stack, RodQuality quality, Loot.Rarity type, int rarity) {
        RecipeHelper.addLoot(stack, quality, type, rarity, -1);
    }

    public static void addOverworldLoot(Item item, RodQuality quality, Loot.Rarity type, int rarity) {
        RecipeHelper.addOverworldLoot(new ItemStack(item), quality, type, rarity);
    }

    public static void addOverworldLoot(ItemStack stack, RodQuality quality, Loot.Rarity type, int rarity) {
        RecipeHelper.addLoot(stack, quality, type, rarity, 0);
    }

    public static void addLoot(Item item, RodQuality quality, Loot.Rarity type, int rarity) {
        RecipeHelper.addLoot(new ItemStack(item), quality, type, rarity);
    }

    public static void addLoot(ItemStack stack, RodQuality quality, Loot.Rarity type, int rarity) {
        RecipeHelper.addLoot(stack, quality, type, rarity, Short.MAX_VALUE);
    }

    public static void addLoot(ItemStack stack, RodQuality quality, Loot.Rarity type, int rarity, int dimension) {
        Fishing.loot.addLoot(new Loot(stack, quality, type, rarity, dimension, false));
    }

    public static void addExactLoot(ItemStack stack, RodQuality quality, Loot.Rarity type, int rarity, int dimension) {
        Fishing.loot.addLoot(new Loot(stack, quality, type, rarity, dimension, true));
    }
}

