/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.helpers;

import mariculture.core.Core;
import mariculture.core.lib.MetalRates;
import mariculture.core.util.FluidDictionary;
import mariculture.fishery.FishFoodHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidHelper {
    public static void process(IInventory invent, int in, int out) {
        ItemStack result = FluidHelper.getFluidResult((IFluidHandler)invent, invent.func_70301_a(in), invent.func_70301_a(out));
        if (result != null) {
            invent.func_70298_a(in, 1);
            if (result.field_77993_c != Core.air.field_71990_ca) {
                if (invent.func_70301_a(out) == null) {
                    invent.func_70299_a(out, result.func_77946_l());
                } else if (invent.func_70301_a((int)out).field_77993_c == result.field_77993_c) {
                    ItemStack stack = invent.func_70301_a(out);
                    ++stack.field_77994_a;
                    invent.func_70299_a(out, stack);
                }
            }
        }
    }

    public static boolean isFluidOrEmpty(ItemStack stack) {
        return FluidHelper.isEmpty(stack) || FluidHelper.isFilled(stack) || FluidHelper.isVoid(stack) || FishFoodHandler.isFishFood(stack);
    }

    public static boolean isEmpty(ItemStack stack) {
        return FluidContainerRegistry.isEmptyContainer((ItemStack)stack);
    }

    public static boolean isFilled(ItemStack stack) {
        return FluidContainerRegistry.isFilledContainer((ItemStack)stack);
    }

    public static boolean isVoid(ItemStack stack) {
        return stack != null && stack.func_77973_b().field_77779_bT == Core.bottles.field_77779_bT && stack.func_77960_j() == 0;
    }

    public static boolean isIContainer(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof IFluidContainerItem;
    }

    public static ItemStack getFluidResult(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        if (top != null) {
            if (FluidHelper.isVoid(top)) {
                return FluidHelper.doVoid(tile, top, bottom);
            }
            if (FluidHelper.isEmpty(top)) {
                return FluidHelper.doFill(tile, top, bottom);
            }
            if (FluidHelper.isFilled(top)) {
                return FluidHelper.doEmpty(tile, top, bottom);
            }
            if (FluidHelper.isIContainer(top)) {
                return FluidHelper.doIContainer(tile, top, bottom);
            }
            if (FishFoodHandler.isFishFood(top)) {
                return FluidHelper.addFishFood(tile, top);
            }
        }
        return null;
    }

    private static ItemStack addFishFood(IFluidHandler tile, ItemStack stack) {
        int increase;
        int fill;
        if (FishFoodHandler.isFishFood(stack) && (fill = tile.fill(ForgeDirection.UP, FluidRegistry.getFluidStack((String)FluidDictionary.fish_food, (int)(increase = FishFoodHandler.getValue(stack))), false)) >= increase) {
            tile.fill(ForgeDirection.UP, FluidRegistry.getFluidStack((String)FluidDictionary.fish_food, (int)increase), true);
            return new ItemStack(Core.air);
        }
        return null;
    }

    public static ItemStack getEmptyContainerForFilledItem(ItemStack filledContainer) {
        if (filledContainer == null) {
            return null;
        }
        FluidContainerRegistry.FluidContainerData[] data = FluidContainerRegistry.getRegisteredFluidContainerData();
        for (int i = 0; i < data.length; ++i) {
            if (data[i].filledContainer.field_77993_c != filledContainer.field_77993_c || data[i].filledContainer.func_77960_j() != filledContainer.func_77960_j()) continue;
            return data[i].emptyContainer;
        }
        return null;
    }

    public static int getRequiredVolumeForBlock(Fluid fluid) {
        FluidContainerRegistry.FluidContainerData[] data = FluidContainerRegistry.getRegisteredFluidContainerData();
        int highest = -1;
        for (int j = 0; j < data.length; ++j) {
            if (data[j].fluid.fluidID != fluid.getID()) continue;
            if (data[j].fluid.amount > highest) {
                highest = data[j].fluid.amount;
            }
            if (data[j].emptyContainer.field_77993_c != Item.field_77788_aw.field_77779_bT) continue;
            return data[j].fluid.amount;
        }
        return highest;
    }

    private static ItemStack doEmpty(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        ItemStack result = FluidHelper.getEmptyContainerForFilledItem(top);
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)top);
        if (result != null && tile.fill(ForgeDirection.UNKNOWN, fluid, false) == fluid.amount && FluidHelper.matches(top, bottom, result)) {
            tile.fill(ForgeDirection.UNKNOWN, fluid, true);
            return result;
        }
        return null;
    }

    private static ItemStack doFill(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        ItemStack result = FluidContainerRegistry.fillFluidContainer((FluidStack)tile.drain(ForgeDirection.UNKNOWN, 100000, false), (ItemStack)top);
        if (result != null && FluidHelper.matches(top, bottom, result)) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
            tile.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
            return result;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ItemStack doIContainer(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        if (bottom != null) {
            return null;
        }
        IFluidContainerItem container = (IFluidContainerItem)top.func_77973_b();
        FluidStack fluid = container.getFluid(top);
        if (fluid != null) {
            FluidStack stack = container.drain(top, 1000000, false);
            if (stack == null) return top;
            stack.amount = tile.fill(ForgeDirection.UNKNOWN, stack, false);
            if (stack.amount <= 0) return null;
            container.drain(top, stack.amount, true);
            tile.fill(ForgeDirection.UNKNOWN, stack, true);
            return top;
        } else {
            FluidStack stack = tile.drain(ForgeDirection.UNKNOWN, MetalRates.INGOT, true);
            if (stack == null || stack.amount <= 0) return null;
            container.fill(top, stack, true);
        }
        return top;
    }

    public static ItemStack doVoid(IFluidHandler tile, ItemStack top, ItemStack bottom) {
        if (FluidHelper.matches(top, bottom, new ItemStack(Core.bottles, 1, 20))) {
            FluidStack fluid = tile.drain(ForgeDirection.UNKNOWN, Short.MAX_VALUE, false);
            if (fluid == null || fluid != null && fluid.amount <= 0) {
                return null;
            }
            tile.drain(ForgeDirection.UNKNOWN, Short.MAX_VALUE, true);
            return new ItemStack(Core.bottles, 1, 20);
        }
        return null;
    }

    public static boolean matches(ItemStack top, ItemStack bottom, ItemStack result) {
        if (bottom == null) {
            return true;
        }
        return bottom.func_77969_a(result) && bottom.field_77994_a < 64 && bottom.field_77994_a < bottom.func_77976_d();
    }

    public static String getName(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        if (fluid.getID() > 0) {
            String name = fluid.getLocalizedName();
            if (name.startsWith("fluid.") && (name = name.substring(6)).startsWith("tile.")) {
                name = name.substring(5);
            }
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return null;
    }

    public static boolean handleFillOrDrain(IFluidHandler tank, EntityPlayer player, ForgeDirection side) {
        ItemStack heldItem = player.field_71071_by.func_70448_g();
        FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)heldItem);
        ItemStack newHeld = FluidHelper.getEmptyContainerForFilledItem(heldItem);
        if (newHeld != null && newHeld.field_77994_a == 0) {
            newHeld.field_77994_a = 1;
        }
        if (liquid != null) {
            int amount = tank.fill(ForgeDirection.UNKNOWN, liquid, false);
            if (amount >= liquid.amount) {
                tank.fill(ForgeDirection.UNKNOWN, liquid, true);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (heldItem.field_77994_a == 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, newHeld);
                    } else {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        if (!player.field_71071_by.func_70441_a(newHeld)) {
                            player.func_71021_b(newHeld);
                        }
                    }
                }
                return true;
            }
            return true;
        }
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)heldItem)) {
            ItemStack result = FluidContainerRegistry.fillFluidContainer((FluidStack)tank.drain(ForgeDirection.UNKNOWN, 100000, false), (ItemStack)heldItem);
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
            if (result != null) {
                tank.drain(side, fluid.amount, true);
                if (!player.field_71075_bZ.field_75098_d) {
                    if (heldItem.field_77994_a == 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, result);
                    } else {
                        player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                        if (!player.field_71071_by.func_70441_a(result)) {
                            player.func_71021_b(result);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }
}

