/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.core.Core;
import mariculture.core.blocks.TileOyster;
import mariculture.core.handlers.PearlGenHandler;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.lib.Extra;
import mariculture.core.lib.OreGeneration;
import mariculture.core.lib.WorldGeneration;
import mariculture.core.world.WorldGenGas;
import mariculture.core.world.WorldGenLimestone;
import mariculture.core.world.WorldGenOre;
import mariculture.plugins.PluginBiomesOPlenty;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;

public class WorldGenHandler
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        switch (world.field_73011_w.field_76574_g) {
            case -1: {
                break;
            }
            case 0: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
            case 1: {
                break;
            }
            default: {
                this.generateSurface(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    private void generateSurface(World world, Random random, int x, int z) {
        WorldGenHandler.generateGas(world, random, x, z);
        WorldGenHandler.generateBauxite(world, random, x, z);
        WorldGenHandler.generateCopper(world, random, x, z);
        WorldGenHandler.generateLimestone(world, random, x, z);
        WorldGenHandler.generateRutile(world, random, x, z);
        WorldGenHandler.generateOyster(world, random, x, z);
    }

    public static void generateBauxite(World world, Random random, int x, int z) {
        if (OreGeneration.BAUXITE_ON) {
            for (int i = 0; i < OreGeneration.BAUXITE_TOTAL; ++i) {
                int posX = x + random.nextInt(16);
                int posY = OreGeneration.BAUXITE_MIN + random.nextInt(OreGeneration.BAUXITE_MAX - OreGeneration.BAUXITE_MIN);
                int posZ = z + random.nextInt(16);
                new WorldGenOre(Core.ores.field_71990_ca, 0, OreGeneration.BAUXITE_VEIN, Block.field_71981_t.field_71990_ca).func_76484_a(world, random, posX, posY, posZ);
            }
        }
    }

    public static void generateGas(World world, Random random, int x, int z) {
        if (OreGeneration.NATURAL_GAS_ON && random.nextInt(OreGeneration.NATURAL_GAS_CHANCE) == 0 && WorldGenHandler.isOceanBiome(world, x, z)) {
            int posX = x + random.nextInt(16);
            int posY = OreGeneration.NATURAL_GAS_MIN + random.nextInt(OreGeneration.NATURAL_GAS_MAX - OreGeneration.NATURAL_GAS_MIN);
            int posZ = z + random.nextInt(16);
            new WorldGenGas(Core.air.field_71990_ca, 0, OreGeneration.NATURAL_GAS_VEIN, Block.field_71981_t.field_71990_ca).func_76484_a(world, random, posX, posY, posZ);
        }
    }

    public static void generateCopper(World world, Random random, int x, int z) {
        if (OreGeneration.COPPER_ON) {
            for (int i = 0; i < OreGeneration.COPPER_TOTAL; ++i) {
                int posX = x + random.nextInt(16);
                int posY = OreGeneration.COPPER_MIN + random.nextInt(OreGeneration.COPPER_MAX - OreGeneration.COPPER_MIN);
                int posZ = z + random.nextInt(16);
                new WorldGenOre(Core.ores.field_71990_ca, 1, OreGeneration.COPPER_VEIN, Block.field_71981_t.field_71990_ca).func_76484_a(world, random, posX, posY, posZ);
            }
        }
    }

    public static void generateLimestone(World world, Random random, int x, int z) {
        if (OreGeneration.LIMESTONE) {
            for (int i = 0; i < OreGeneration.LIMESTONE_CHANCE; ++i) {
                int posZ;
                int posX = x + random.nextInt(16);
                if (!WorldGenHandler.isRiverBiome(world, posX, posZ = z + random.nextInt(16)) || world.func_72825_h(posX, posZ) < OreGeneration.LIMESTONE_MAX_DEPTH || !BlockHelper.isWater(world, posX, world.func_72825_h(posX, posZ) + 1, posZ)) continue;
                new WorldGenLimestone(OreGeneration.LIMESTONE_VEIN).generate(world, random, posX, posZ);
            }
        }
    }

    public static void generateRutile(World world, Random random, int x, int z) {
        int posZ;
        int posX;
        if (!OreGeneration.LIMESTONE && OreGeneration.RUTILE && WorldGenHandler.isRiverBiome(world, posX = x + random.nextInt(16), posZ = z + random.nextInt(16))) {
            for (int i = 0; i < OreGeneration.RUTILE_CHANCE / 10; ++i) {
                posX = x + random.nextInt(16);
                int posY = 54 + random.nextInt(10);
                posZ = z + random.nextInt(16);
                new WorldGenOre(Core.ores.field_71990_ca, 2, 2, Block.field_71981_t.field_71990_ca).func_76484_a(world, random, posX, posY, posZ);
            }
        }
    }

    public static boolean isRiverBiome(World world, int x, int z) {
        if (!Extra.RIVER_FORCE && BiomeDictionary.isBiomeOfType((BiomeGenBase)world.func_72959_q().func_76935_a(x, z), (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
            return true;
        }
        int id = world.func_72959_q().func_76935_a((int)x, (int)z).field_76756_M;
        for (int i = 0; i < Extra.RIVER_BIOMES.length; ++i) {
            if (Extra.RIVER_BIOMES[i] <= -1 || id != Extra.RIVER_BIOMES[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isOceanBiome(World world, int x, int z) {
        if (!Extra.OCEAN_FORCE && MaricultureHandlers.environment.getSalinity(world, x, z) == Environment.Salinity.SALINE) {
            return true;
        }
        int id = world.func_72959_q().func_76935_a((int)x, (int)z).field_76756_M;
        for (int i = 0; i < Extra.OCEAN_BIOMES.length; ++i) {
            if (Extra.OCEAN_BIOMES[i] <= -1 || id != Extra.OCEAN_BIOMES[i]) continue;
            return true;
        }
        return false;
    }

    public static void generateOyster(World world, Random random, int x, int z) {
        if (WorldGeneration.OYSTER_ENABLED) {
            for (int j = 0; j < WorldGeneration.OYSTER_PER_CHUNK; ++j) {
                int chance;
                int n = chance = PluginBiomesOPlenty.isBiome(world, x, z, PluginBiomesOPlenty.Biome.CORAL) ? WorldGeneration.OYSTER_CHANCE : WorldGeneration.OYSTER_CHANCE * 2;
                if (random.nextInt(chance) != 0) continue;
                int randMeta = random.nextInt(4);
                int randX = x - 8 + random.nextInt(4);
                int randZ = z - 8 + random.nextInt(4);
                int blockY = world.func_72825_h(randX, randZ);
                if (MaricultureHandlers.environment.getSalinity(world, randX, randZ) != Environment.Salinity.SALINE || !Core.oyster.func_71854_d(world, randX, blockY, randZ)) continue;
                world.func_72832_d(randX, blockY, randZ, Core.oyster.field_71990_ca, randMeta, 2);
                TileOyster oyster = (TileOyster)world.func_72796_p(randX, blockY, randZ);
                if (oyster == null || random.nextInt(WorldGeneration.OYSTER_PEARL_CHANCE) != 0) continue;
                oyster.func_70299_a(0, PearlGenHandler.getRandomPearl(random));
            }
        }
    }
}

