/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import mariculture.core.handlers.LogHandler;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.helpers.StackHelper;
import mariculture.core.lib.Compatibility;
import mariculture.core.lib.Extra;
import mariculture.plugins.Plugins;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.oredict.OreDictionary;

public class OreDicHandler {
    public static final HashMap<String, ArrayList<String>> entries = new HashMap();
    public static final HashMap<String, Integer[]> specials = new HashMap();
    public static final HashMap<String, ArrayList<ItemStack>> items = new HashMap();

    public static void registerWildCards() {
        OreDicHandler.registerWildcard(new ItemStack(Block.field_71988_x), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack((Block)Block.field_72092_bO), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack(Block.field_71951_J), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack(Block.field_71987_y), new Integer[]{0, 1, 2, 3});
        OreDicHandler.registerWildcard(new ItemStack((Block)Block.field_71952_K), new Integer[]{0, 1, 2, 3});
        for (Plugins.Plugin plugin : Plugins.plugins) {
            plugin.registerWildcards();
        }
    }

    @ForgeSubscribe
    public void onOreDictionaryRegistration(OreDictionary.OreRegisterEvent event) {
        if (entries.size() < 1) {
            String[] ores;
            for (String ore : ores = OreDictionary.getOreNames()) {
                ArrayList stacks = OreDictionary.getOres((String)ore);
                for (ItemStack stack : stacks) {
                    if (stack == null || ore == null || ore.equals("")) continue;
                    if (stack.func_77973_b() == null || stack.func_77960_j() == Short.MAX_VALUE) {
                        this.addSpecial(stack, ore);
                        continue;
                    }
                    OreDicHandler.add(stack, ore);
                }
            }
        }
        if (event.Ore.func_77960_j() == Short.MAX_VALUE) {
            this.addSpecial(event.Ore, event.Name);
        } else {
            OreDicHandler.add(event.Ore, event.Name);
        }
    }

    public static void registerWildcard(ItemStack stack, Integer[] metas) {
        String name = "" + stack.field_77993_c;
        specials.put(name, metas);
        LogHandler.log(Level.INFO, "Successfully registered wildcard for " + name + "(" + stack.toString() + ")");
    }

    private void addSpecial(ItemStack stack, String ore) {
        String name = "" + stack.field_77993_c;
        Integer[] meta = specials.get(name);
        if (meta == null) {
            return;
        }
        for (Integer i : meta) {
            OreDicHandler.add(new ItemStack(stack.func_77973_b(), 1, i.intValue()), ore);
        }
    }

    public static void add(ItemStack stack, String name) {
        if (!OreDicHandler.isWhitelisted(name)) {
            return;
        }
        for (String str : Compatibility.BLACKLIST_PREFIX_DEFAULT) {
            if (!name.startsWith(str)) continue;
            return;
        }
        for (String str : Compatibility.BLACKLIST_ITEMS) {
            ItemStack check = StackHelper.getStackFromString(str);
            if (check == null || check.field_77993_c != stack.field_77993_c || check.func_77960_j() != stack.func_77960_j()) continue;
            return;
        }
        String id = OreDicHandler.convert(stack);
        ArrayList<Object> list = entries.containsKey(id) ? entries.get(id) : new ArrayList();
        list.add(name);
        entries.put(id, list);
        ArrayList<Object> stacks = items.get(name) != null ? items.get(name) : new ArrayList();
        stacks.add(stack);
        items.put(name, stacks);
        if (Extra.DEBUG_ON) {
            LogHandler.log(Level.INFO, stack.toString() + " registered for ore dic handling as " + name);
        }
    }

    public static String convert(ItemStack stack) {
        try {
            return stack.field_77993_c + ":" + stack.func_77960_j();
        }
        catch (Exception e) {
            return stack.field_77993_c + ":" + Short.MAX_VALUE;
        }
    }

    public static boolean isInDictionary(ItemStack stack) {
        return entries.get(OreDicHandler.convert(stack)) != null;
    }

    public static boolean areEqual(ItemStack stack1, ItemStack stack2) {
        if (!OreDicHandler.isInDictionary(stack1) || !OreDicHandler.isInDictionary(stack2)) {
            return false;
        }
        ArrayList<String> oreNames1 = entries.get(OreDicHandler.convert(stack1));
        ArrayList<String> oreNames2 = entries.get(OreDicHandler.convert(stack2));
        if (oreNames1 == null || oreNames2 == null) {
            return false;
        }
        for (String ores1 : oreNames1) {
            for (String ores2 : oreNames2) {
                if (!ores1.equals(ores2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitelisted(String name) {
        if (Compatibility.ENABLE_WHITELIST) {
            for (String whitelist : Compatibility.WHITELIST) {
                if (!name.startsWith(whitelist)) continue;
                return true;
            }
            return false;
        }
        for (String blacklist : Compatibility.BLACKLIST) {
            if (!name.equals(blacklist)) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getNextValidEntry(ItemStack stack) {
        NBTTagCompound tag = stack.field_77990_d;
        if (tag != null && tag.func_74764_b("OreDictionaryDisplay")) {
            String old = "";
            NBTTagCompound display = tag.func_74775_l("OreDictionaryDisplay");
            NBTTagList lore = display.func_74761_m("Lore");
            if (lore != null && lore.func_74745_c() > 0) {
                old = ((NBTTagString)lore.func_74743_b((int)0)).field_74751_a;
            }
            if (old != null) {
                return OreDicHandler.getNextValidEntry(stack, old);
            }
        }
        return OreDicHandler.getNextValidEntry(stack, OreDicHelper.getDictionaryName(stack));
    }

    private static ItemStack getNextValidEntry(ItemStack stack, String name) {
        String converted = OreDicHandler.convert(stack);
        boolean found = false;
        ArrayList<ItemStack> stacks = items.get(name);
        if (stacks == null || stacks.size() < 1) {
            return stack;
        }
        for (ItemStack item : stacks) {
            if (found && item != null && !OreDicHandler.convert(item).equals(converted)) {
                ItemStack ret = item.func_77946_l();
                if (!ret.func_77942_o()) {
                    ret.func_77982_d(new NBTTagCompound());
                }
                if (!ret.field_77990_d.func_74764_b("OreDictionaryDisplay")) {
                    ret.field_77990_d.func_74782_a("OreDictionaryDisplay", (NBTBase)new NBTTagCompound());
                }
                ret.field_77990_d.func_74775_l("OreDictionaryDisplay").func_74782_a("Lore", (NBTBase)OreDicHandler.addAllTags(ret, name));
                return ret;
            }
            found = OreDicHandler.convert(item).equals(converted);
        }
        ItemStack ret = stacks.get(0).func_77946_l();
        if (!ret.func_77942_o()) {
            ret.func_77982_d(new NBTTagCompound());
        }
        if (!ret.field_77990_d.func_74764_b("OreDictionaryDisplay")) {
            ret.field_77990_d.func_74782_a("OreDictionaryDisplay", (NBTBase)new NBTTagCompound());
        }
        ret.field_77990_d.func_74775_l("OreDictionaryDisplay").func_74782_a("Lore", (NBTBase)OreDicHandler.addAllTags(ret, name));
        return ret;
    }

    public static String getNextString(ItemStack stack, String name) {
        boolean found = false;
        ArrayList<String> names = entries.get(OreDicHandler.convert(stack));
        if (names == null) {
            return name;
        }
        for (String entry : names) {
            if (found && !entry.equals(name)) {
                return entry;
            }
            found = entry.equals(name);
        }
        return names.get(0);
    }

    public static NBTTagList addAllTags(ItemStack stack, String name) {
        NBTTagList lore = new NBTTagList();
        lore.func_74742_a((NBTBase)new NBTTagString("OreDicName1st", name));
        String last = "";
        ArrayList<String> names = entries.get(OreDicHandler.convert(stack));
        if (names == null) {
            return lore;
        }
        for (String entry : names) {
            if (entry.equals(name) || last.equals(entry)) continue;
            lore.func_74742_a((NBTBase)new NBTTagString("OreDicName2nd", entry));
            last = entry;
        }
        return lore;
    }
}

