/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.gui.feature;

import java.util.List;
import mariculture.core.gui.GuiMariculture;
import mariculture.core.gui.feature.Feature;
import mariculture.core.network.Packet115EjectSetting;
import mariculture.core.util.IEjectable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public class FeatureEject
extends Feature {
    public IEjectable tile;
    public int x;
    public int y;
    public int z;

    public FeatureEject(IEjectable tile) {
        this.tile = tile;
        this.x = ((TileEntity)tile).field_70329_l;
        this.y = ((TileEntity)tile).field_70330_m;
        this.z = ((TileEntity)tile).field_70327_n;
    }

    @Override
    public void addTooltip(List tooltip, int mouseX, int mouseY) {
        if (mouseX >= 177 && mouseX <= 192 && mouseY >= 99 && mouseY <= 114) {
            tooltip.add("\u00a7b" + StatCollector.func_74838_a((String)("ejectmode." + this.tile.getEjectSetting().toString().toLowerCase())));
        }
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY) {
        if (mouseX >= 177 && mouseX <= 192 && mouseY >= 99 && mouseY <= 114) {
            Minecraft.func_71410_x().field_71439_g.field_71174_a.func_72552_c(new Packet115EjectSetting(this.x, this.y, this.z).build());
        }
    }

    @Override
    public void draw(GuiMariculture gui, int x, int y, int mouseX, int mouseY) {
        super.draw(gui, x, y, mouseX, mouseY);
        int offsetY = mouseX >= 177 && mouseX <= 192 && mouseY >= 99 && mouseY <= 114 ? -18 : 0;
        int color = 7908166;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
        gui.func_73729_b(x + 175, y + 96, 176, 122, 21, 22);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        switch (this.tile.getEjectSetting()) {
            case NONE: {
                gui.func_73729_b(x + 177, y + 99, 179, 166 + offsetY, 16, 16);
                break;
            }
            case ITEM: {
                gui.func_73729_b(x + 177, y + 99, 239, 166 + offsetY, 16, 16);
                break;
            }
            case FLUID: {
                gui.func_73729_b(x + 177, y + 99, 219, 166 + offsetY, 16, 16);
                break;
            }
            case ITEMNFLUID: {
                gui.func_73729_b(x + 177, y + 99, 199, 166 + offsetY, 16, 16);
                break;
            }
            default: {
                gui.func_73729_b(x + 177, y + 99, 219, 166 + offsetY, 16, 16);
            }
        }
    }

    public static enum EjectSetting {
        NONE,
        ITEM,
        FLUID,
        ITEMNFLUID;


        public static EjectSetting readFromNBT(NBTTagCompound nbt) {
            return EjectSetting.values()[nbt.func_74771_c("EjectSetting")];
        }

        public static void writeToNBT(NBTTagCompound nbt, EjectSetting setting) {
            nbt.func_74774_a("EjectSetting", (byte)setting.ordinal());
        }

        public static boolean canEject(EjectSetting mode, EjectSetting type) {
            switch (mode) {
                case NONE: {
                    return false;
                }
                case ITEM: {
                    return type.equals((Object)ITEM);
                }
                case FLUID: {
                    return type.equals((Object)FLUID);
                }
                case ITEMNFLUID: {
                    return true;
                }
            }
            return false;
        }

        public boolean canEject(EjectSetting type) {
            if (this == ITEM) {
                return type == ITEM;
            }
            if (this == FLUID) {
                return type == FLUID;
            }
            return this == ITEMNFLUID;
        }

        public static EjectSetting toggle(EjectSetting block, EjectSetting setting) {
            switch (block) {
                case ITEM: {
                    return setting == ITEM ? NONE : ITEM;
                }
                case FLUID: {
                    return setting == FLUID ? NONE : FLUID;
                }
                case ITEMNFLUID: {
                    int i = setting.ordinal() + 1;
                    if (i < EjectSetting.values().length) {
                        return EjectSetting.values()[i];
                    }
                    return NONE;
                }
            }
            return NONE;
        }
    }
}

