/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import java.util.ArrayList;
import mariculture.api.core.Environment;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.blocks.base.TileMultiBlock;
import mariculture.core.blocks.base.TileMultiMachineTank;
import mariculture.core.gui.ContainerMariculture;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.gui.feature.FeatureNotifications;
import mariculture.core.gui.feature.FeatureRedstone;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.lib.Extra;
import mariculture.core.lib.MachineSpeeds;
import mariculture.core.lib.MetalRates;
import mariculture.core.network.Packets;
import mariculture.core.util.IHasNotification;
import mariculture.core.util.Rand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileLiquifier
extends TileMultiMachineTank
implements IHasNotification {
    public static final int MAX_TEMP = 25000;
    private int temp;
    private boolean canFuel;
    private int cooling;
    public static final int liquid_in = 3;
    public static final int liquid_out = 4;
    public static final int[] in = new int[]{5, 6};
    public static final int fuel = 7;
    public static final int out = 8;
    public FuelHandler fuelHandler;
    private int burnHeight = 0;

    public TileLiquifier() {
        this.max = MachineSpeeds.getLiquifierSpeed();
        this.inventory = new ItemStack[9];
        this.needsInit = true;
    }

    public int[] func_94128_d(int side) {
        return new int[]{3, 4, 5, 6, 7, 8};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        if (FluidHelper.isFluidOrEmpty(stack)) {
            return slot == 3;
        }
        if (MaricultureHandlers.smelter.getFuelInfo(stack) != null) {
            return slot == 7;
        }
        return slot == 5 || slot == 6;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 8 || slot == 4;
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.ITEMNFLUID;
    }

    @Override
    public boolean isNotificationVisible(FeatureNotifications.NotificationType type) {
        return false;
    }

    @Override
    public boolean canWork() {
        return this.hasTemperature() && this.hasItem() && this.rsAllowsWork() && this.hasRoom();
    }

    public boolean hasTemperature() {
        return this.temp > 0;
    }

    public boolean hasItem() {
        return this.inventory[in[0]] != null || this.inventory[in[1]] != null;
    }

    public boolean hasRoom() {
        return this.canMelt(0) || this.canMelt(1);
    }

    private boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return stack1.field_77993_c == stack2.field_77993_c && stack1.func_77960_j() == stack2.func_77960_j();
    }

    @Override
    public void updateMasterMachine() {
        if (!this.field_70331_k.field_72995_K) {
            this.heatUp();
            this.coolDown();
            if (this.canWork) {
                this.processed += this.speed * 50;
                if (this.processed >= this.max) {
                    this.processed = 0;
                    if (this.canWork()) {
                        if (this.canMelt(0)) {
                            this.melt(0);
                        }
                        if (this.canMelt(1)) {
                            this.melt(1);
                        }
                    }
                    this.canWork = this.canWork();
                }
            } else {
                this.processed = 0;
            }
            if (this.processed <= 0) {
                this.processed = 0;
            }
            if (this.onTick(100) && this.tank.getFluidAmount() > 0 && FeatureRedstone.RedstoneMode.canWork(this, this.mode) && FeatureEject.EjectSetting.canEject(this.setting, FeatureEject.EjectSetting.FLUID)) {
                this.helper.ejectFluid(new int[]{5000, MetalRates.BLOCK, 1000, MetalRates.ORE, MetalRates.INGOT, MetalRates.NUGGET, 1});
            }
        }
    }

    @Override
    public void updateSlaveMachine() {
        TileLiquifier mstr;
        if (this.onTick(100) && (mstr = (TileLiquifier)this.getMaster()) != null && mstr.tank.getFluidAmount() > 0 && FeatureRedstone.RedstoneMode.canWork(this, mstr.mode) && FeatureEject.EjectSetting.canEject(mstr.setting, FeatureEject.EjectSetting.FLUID)) {
            this.helper.ejectFluid(new int[]{5000, MetalRates.BLOCK, 1000, MetalRates.ORE, MetalRates.INGOT, MetalRates.NUGGET, 1});
        }
    }

    public boolean canFuel() {
        IFluidHandler handler;
        FluidTankInfo[] info;
        if (this.fuelHandler.info != null) {
            return false;
        }
        if (!this.rsAllowsWork()) {
            return false;
        }
        if (MaricultureHandlers.smelter.getFuelInfo(this.inventory[7]) != null) {
            return true;
        }
        if (this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) instanceof IFluidHandler && (info = (handler = (IFluidHandler)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n)).getTankInfo(ForgeDirection.UP)) != null && info[0].fluid != null && info[0].fluid.amount >= 10) {
            return MaricultureHandlers.smelter.getFuelInfo(info[0].fluid) != null;
        }
        return false;
    }

    public void heatUp() {
        if (this.fuelHandler == null) {
            this.fuelHandler = new FuelHandler();
        }
        if (this.onTick(20)) {
            this.canFuel = this.canFuel();
        }
        if (this.canFuel) {
            this.fuelHandler.set(this.getInfo());
            this.canFuel = false;
        }
        if (this.fuelHandler.info != null) {
            this.temp = this.fuelHandler.tick(this.temp, MaricultureHandlers.upgrades.hasUpgrade("ethereal", this));
            if (this.temp >= this.max) {
                this.temp = this.max;
            }
        }
    }

    public void coolDown() {
        if (this.cooling <= 0) {
            this.cooling = Math.max(1, Environment.Temperature.getCoolingSpeed(MaricultureHandlers.environment.getBiomeTemperature(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n)));
        }
        if (this.onTick(20)) {
            this.temp -= this.cooling;
            if (this.temp <= 0) {
                this.temp = 0;
            }
        }
    }

    public FuelInfo getInfo() {
        FuelInfo info = MaricultureHandlers.smelter.getFuelInfo(this.inventory[7]);
        if (info == null) {
            IFluidHandler handler = (IFluidHandler)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
            FluidTankInfo[] tank = handler.getTankInfo(ForgeDirection.UP);
            if (tank.length > 0 && tank[0] != null && tank[0].fluid != null) {
                info = MaricultureHandlers.smelter.getFuelInfo(tank[0].fluid);
                handler.drain(ForgeDirection.UP, new FluidStack(tank[0].fluid.fluidID, 10), true);
            }
        } else {
            this.func_70298_a(7, 1);
        }
        return info;
    }

    public boolean canMelt(int slot) {
        int other = slot == 0 ? 1 : 0;
        RecipeSmelter recipe = MaricultureHandlers.smelter.getResult(this.inventory[in[slot]], this.inventory[in[other]], this.getTemperatureScaled(2000));
        if (recipe == null) {
            return false;
        }
        int fluidAmount = this.getFluidAmount(recipe.input, recipe.fluid.amount);
        FluidStack fluid = recipe.fluid.copy();
        fluid.amount = fluidAmount;
        if (this.tank.fill(fluid, false) < fluid.amount) {
            return false;
        }
        if (recipe.output == null) {
            return true;
        }
        if (this.setting.canEject(FeatureEject.EjectSetting.ITEM)) {
            return true;
        }
        return this.inventory[8] == null || this.areStacksEqual(this.inventory[8], recipe.output) && this.inventory[8].field_77994_a + recipe.output.field_77994_a <= this.inventory[8].func_77976_d();
    }

    public void melt(int slot) {
        int other = slot == 0 ? 1 : 0;
        RecipeSmelter recipe = MaricultureHandlers.smelter.getResult(this.inventory[in[slot]], this.inventory[in[other]], this.getTemperatureScaled(2000));
        if (recipe == null) {
            return;
        }
        if (recipe.input2 != null) {
            this.func_70298_a(in[slot], recipe.input.field_77994_a);
            if (slot == 0) {
                this.func_70298_a(in[1], recipe.input2.field_77994_a);
            } else {
                this.func_70298_a(in[0], recipe.input2.field_77994_a);
            }
            this.tank.fill(recipe.fluid.copy(), true);
            if (recipe.output != null && recipe.chance > 0 && Rand.nextInt(recipe.chance)) {
                this.helper.insertStack(recipe.output.func_77946_l(), new int[]{8});
            }
        } else {
            this.func_70298_a(in[slot], recipe.input.field_77994_a);
            int fluidAmount = this.getFluidAmount(recipe.input, recipe.fluid.amount);
            FluidStack fluid = recipe.fluid.copy();
            fluid.amount = fluidAmount;
            this.tank.fill(fluid, true);
            if (recipe.output != null && recipe.chance > 0 && Rand.nextInt(recipe.chance)) {
                this.helper.insertStack(recipe.output.func_77946_l(), new int[]{8});
            }
        }
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        int realID = id - this.offset;
        switch (realID) {
            case 0: {
                this.temp = value;
            }
            case 1: {
                this.burnHeight = value;
            }
        }
    }

    public int getBurnTimeRemainingScaled() {
        return this.burnHeight;
    }

    @Override
    public void sendGUINetworkData(ContainerMariculture container, EntityPlayer player) {
        super.sendGUINetworkData(container, player);
        Packets.updateGUI(player, container, 0 + this.offset, this.temp);
        if (this.fuelHandler.info != null) {
            this.burnHeight = 11 - this.fuelHandler.tick * 12 / this.fuelHandler.info.ticksPer;
            Packets.updateGUI(player, container, 1 + this.offset, this.burnHeight);
        } else {
            Packets.updateGUI(player, container, 1 + this.offset, 0);
        }
    }

    public int getTemperatureScaled(int i) {
        return this.temp * i / 25000;
    }

    public String getRealTemperature() {
        return "" + this.temp * 2000 / 25000;
    }

    public int getFluidAmount(ItemStack stack, int amount) {
        String name;
        if (OreDicHelper.isInDictionary(stack) && (name = OreDicHelper.getDictionaryName(stack)).startsWith("ore")) {
            amount += this.purity * (MetalRates.NUGGET * Extra.PURITY);
        }
        return amount;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.cooling = nbt.func_74762_e("CoolingSpeed");
        this.temp = nbt.func_74762_e("Temperature");
        this.canFuel = nbt.func_74767_n("CanFuel");
        this.fuelHandler = new FuelHandler();
        this.fuelHandler.read(nbt);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("CoolingSpeed", this.cooling);
        nbt.func_74768_a("Temperature", this.temp);
        nbt.func_74757_a("CanFuel", this.canFuel);
        if (this.fuelHandler != null) {
            this.fuelHandler.write(nbt);
        }
    }

    @Override
    public void onBlockPlaced() {
        this.onBlockPlaced(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        Packets.updateTile(this, this.func_70319_e());
    }

    public void onBlockPlaced(int x, int y, int z) {
        ArrayList<TileMultiBlock.MultiPart> parts;
        TileMultiBlock.MultiPart mstr;
        if (this.isPart(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) && !this.isPart(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) && !this.isPart(this.field_70329_l, this.field_70330_m + 2, this.field_70327_n)) {
            mstr = new TileMultiBlock.MultiPart(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            parts = new ArrayList<TileMultiBlock.MultiPart>();
            parts.add(this.setAsSlave(mstr, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n));
            this.setAsMaster(mstr, parts);
        }
        if (this.isPart(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n) && !this.isPart(this.field_70329_l, this.field_70330_m + 1, this.field_70327_n) && !this.isPart(this.field_70329_l, this.field_70330_m - 2, this.field_70327_n)) {
            mstr = new TileMultiBlock.MultiPart(this.field_70329_l, this.field_70330_m - 1, this.field_70327_n);
            parts = new ArrayList();
            parts.add(this.setAsSlave(mstr, this.field_70329_l, this.field_70330_m, this.field_70327_n));
            this.setAsMaster(mstr, parts);
        }
        Packets.updateTile(this, this.func_70319_e());
    }

    @Override
    public boolean isPart(int x, int y, int z) {
        return this.field_70331_k.func_72798_a(x, y, z) == this.func_70311_o().field_71990_ca && this.field_70331_k.func_72805_g(x, y, z) == 3 && !this.isPartnered(x, y, z);
    }

    public class FuelHandler {
        public int usedHeat;
        public int tick;
        public FuelInfo info;

        public void read(NBTTagCompound nbt) {
            if (nbt.func_74767_n("HasHandler")) {
                this.info = new FuelInfo();
                this.info.read(nbt);
            }
        }

        public void write(NBTTagCompound nbt) {
            if (this.info != null) {
                nbt.func_74757_a("HasHandler", true);
                this.info.write(nbt);
            }
        }

        public void set(FuelInfo info) {
            this.info = info;
            this.tick = 0;
            this.usedHeat = 0;
        }

        public int tick(int temp, boolean ethereal) {
            int realUsed = this.usedHeat * 2000 / 25000;
            int realTemp = temp * 2000 / 25000;
            ++this.tick;
            if (realUsed < this.info.maxTempPer && realTemp < this.info.maxTemp) {
                temp += TileLiquifier.this.heat / 3 + 1;
                this.usedHeat += TileLiquifier.this.heat / 3 + 1;
            }
            if (realUsed >= this.info.maxTempPer && !ethereal) {
                this.info = null;
                if (TileLiquifier.this.canFuel()) {
                    TileLiquifier.this.fuelHandler.set(TileLiquifier.this.getInfo());
                } else {
                    TileLiquifier.this.fuelHandler.set(null);
                }
            } else if (this.tick >= this.info.ticksPer) {
                this.info = null;
                if (TileLiquifier.this.canFuel()) {
                    TileLiquifier.this.fuelHandler.set(TileLiquifier.this.getInfo());
                } else {
                    TileLiquifier.this.fuelHandler.set(null);
                }
            }
            return temp;
        }
    }
}

