/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import java.util.List;
import java.util.Random;
import mariculture.core.Core;
import mariculture.core.blocks.base.TileStorageTank;
import mariculture.core.gui.feature.FeatureEject;
import mariculture.core.helpers.BlockTransferHelper;
import mariculture.core.helpers.PlayerHelper;
import mariculture.core.lib.ArmorSlot;
import mariculture.core.lib.Extra;
import mariculture.core.lib.Modules;
import mariculture.core.network.Packet102AirPump;
import mariculture.core.network.Packets;
import mariculture.core.util.FluidDictionary;
import mariculture.core.util.IEjectable;
import mariculture.core.util.Tank;
import mariculture.diving.Diving;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;

public class TileAirPump
extends TileStorageTank
implements IEnergyHandler,
IEjectable {
    protected BlockTransferHelper helper;
    protected EnergyStorage storage = new EnergyStorage(100);
    public boolean animate;
    private double wheelAngle1 = 0.0;
    private double wheelAngle2 = 0.0;
    private Random rand = new Random();
    private int tick;
    public boolean on = true;

    public TileAirPump() {
        this.tank = new Tank(8000);
        this.inventory = new ItemStack[1];
    }

    public double getWheelAngle(int which) {
        if (which == 1) {
            return this.wheelAngle1;
        }
        return this.wheelAngle2;
    }

    public void supplyWithAir(int value, double x, double y, double z) {
        List playerList;
        if (!this.field_70331_k.field_72995_K && this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != null && !(playerList = this.field_70331_k.func_72872_a(EntityPlayer.class, this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n).func_70311_o().func_71872_e(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n).func_72314_b(x, y, z))).isEmpty()) {
            for (int i = 0; i < playerList.size(); ++i) {
                EntityPlayer player = (EntityPlayer)playerList.get(i);
                if (!PlayerHelper.hasArmor(player, ArmorSlot.TOP, Diving.divingTop) || !PlayerHelper.hasArmor(player, ArmorSlot.HAT, Diving.divingHelmet) || !player.func_70055_a(Material.field_76244_g)) continue;
                if (value == 300) {
                    player.func_70050_g(300);
                    continue;
                }
                player.func_70050_g(player.func_70086_ai() + 35);
            }
        }
    }

    public void doPoweredPump() {
        if (Extra.BUILDCRAFT_PUMP) {
            if (this.storage.extractEnergy(100, true) < 100) {
                return;
            }
            this.storage.extractEnergy(100, false);
            if (this.updateAirArea(Type.CHECK)) {
                if (Modules.isActive(Modules.diving)) {
                    this.supplyWithAir(300, 40.0, 50.0, 40.0);
                }
                this.animate = true;
                Packets.updateTile(this, new Packet102AirPump(this.field_70329_l, this.field_70330_m, this.field_70327_n).build());
            }
            this.suckUpGas(4096);
        }
    }

    public boolean suckUpGas(int chance) {
        boolean collected = false;
        for (int x = this.field_70329_l - 6; x < this.field_70329_l + 7; ++x) {
            for (int z = this.field_70327_n - 6; z < this.field_70327_n + 7; ++z) {
                for (int y = this.field_70330_m; y < this.field_70330_m + 10; ++y) {
                    if (this.rand.nextInt(1) != 0 || !this.isNaturalGas(x, y, z) || this.fill(ForgeDirection.UP, FluidRegistry.getFluidStack((String)FluidDictionary.natural_gas, (int)1000), false) < 1000) continue;
                    if (!this.field_70331_k.field_72995_K) {
                        this.fill(ForgeDirection.UP, FluidRegistry.getFluidStack((String)FluidDictionary.natural_gas, (int)1000), true);
                        this.field_70331_k.func_94571_i(x, y, z);
                    }
                    collected = true;
                }
            }
        }
        return collected;
    }

    private boolean isNaturalGas(int x, int y, int z) {
        return this.field_70331_k.func_72798_a(x, y, z) == Core.air.field_71990_ca && this.field_70331_k.func_72805_g(x, y, z) == 0;
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    public void func_70316_g() {
        if (this.helper == null) {
            this.helper = new BlockTransferHelper(this);
        }
        ++this.tick;
        if (this.tick % 100 == 0) {
            this.doPoweredPump();
        }
        if (this.tick % 100 == 0 && this.tank.getFluidAmount() > 0) {
            this.helper.ejectFluid(new int[]{8000, 4000, 2000, 1000, 100, 20, 1});
        }
        if (this.animate) {
            this.wheelAngle1 += 0.1;
            this.wheelAngle2 += 0.1;
            if (this.wheelAngle1 > 6.2198) {
                this.wheelAngle1 = 0.0;
                this.animate = false;
            }
            if (this.wheelAngle2 > 6.2198) {
                this.wheelAngle2 = 0.0;
                this.animate = false;
            }
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        if (Modules.isActive(Modules.diving) && Extra.REDSTONE_PUMP && this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            this.supplyWithAir(30, 25.0, 36.0, 25.0);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.storage.readFromNBT(nbt);
        this.on = nbt.func_74767_n("DisplayOn");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        this.storage.writeToNBT(nbt);
        nbt.func_74757_a("DisplayOn", this.on);
    }

    public boolean updateAirArea(Type type) {
        this.on = !this.on;
        int total = 0;
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int l = 0; l <= 2; ++l) {
                    if ((i == 2 || i == -2) && (j == 2 || j == -2)) continue;
                    int x2 = this.field_70329_l + i;
                    int y2 = this.field_70330_m + l;
                    int z2 = this.field_70327_n + j;
                    if (this.field_70331_k.func_72799_c(x2, y2, z2)) {
                        ++total;
                    }
                    if (type.equals((Object)Type.CHECK)) continue;
                    if (type.equals((Object)Type.DISPLAY_GREEN)) {
                        this.field_70331_k.func_72869_a("happyVillager", (double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, 0.0, 0.0, 0.0);
                        continue;
                    }
                    if (!type.equals((Object)Type.DISPLAY_RED)) continue;
                    this.field_70331_k.func_72869_a("reddust", (double)x2 + 0.5, (double)y2 + 0.5, (double)z2 + 0.5, 0.0, 0.0, 0.0);
                }
            }
        }
        if (type.equals((Object)Type.CHECK)) {
            return total >= 52;
        }
        if (type.equals((Object)Type.DISPLAY)) {
            if (total >= 52) {
                this.updateAirArea(Type.DISPLAY_GREEN);
            } else {
                this.updateAirArea(Type.DISPLAY_RED);
            }
        }
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public boolean canInterface(ForgeDirection from) {
        return true;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public boolean rotate() {
        return false;
    }

    @Override
    public FeatureEject.EjectSetting getEjectSetting() {
        return FeatureEject.EjectSetting.FLUID;
    }

    @Override
    public void setEjectSetting(FeatureEject.EjectSetting setting) {
    }

    @Override
    public FeatureEject.EjectSetting getEjectType() {
        return FeatureEject.EjectSetting.FLUID;
    }

    public static enum Type {
        DISPLAY,
        CHECK,
        CLEAR,
        DISPLAY_GREEN,
        DISPLAY_RED;

    }
}

