/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import mariculture.Mariculture;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Core;
import mariculture.core.blocks.BlockMachine;
import mariculture.core.blocks.TileAirPump;
import mariculture.core.blocks.TileAnvil;
import mariculture.core.blocks.TileBlockCaster;
import mariculture.core.blocks.TileCooling;
import mariculture.core.blocks.TileIngotCaster;
import mariculture.core.blocks.TileNuggetCaster;
import mariculture.core.helpers.BlockHelper;
import mariculture.core.helpers.FluidHelper;
import mariculture.core.helpers.SpawnItemHelper;
import mariculture.core.helpers.cofh.ItemHelper;
import mariculture.core.lib.Extra;
import mariculture.core.lib.MaricultureDamage;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RenderIds;
import mariculture.core.network.Packet120ItemSync;
import mariculture.core.network.Packets;
import mariculture.core.util.Rand;
import mariculture.factory.Factory;
import mariculture.factory.blocks.TileFLUDDStand;
import mariculture.factory.blocks.TileGeyser;
import mariculture.factory.blocks.TileTurbineBase;
import mariculture.factory.blocks.TileTurbineGas;
import mariculture.factory.blocks.TileTurbineHand;
import mariculture.factory.blocks.TileTurbineWater;
import mariculture.fishery.blocks.TileFeeder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.FakePlayer;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class BlockSingle
extends BlockMachine {
    public BlockSingle(int i) {
        super(i, Material.field_76233_E);
        this.func_71849_a(MaricultureTab.tabMariculture);
    }

    public float func_71934_m(World world, int x, int y, int z) {
        switch (world.func_72805_g(x, y, z)) {
            case 0: {
                return 4.0f;
            }
            case 1: {
                return 0.5f;
            }
            case 3: {
                return 2.5f;
            }
            case 4: {
                return 3.0f;
            }
            case 5: {
                return 5.0f;
            }
            case 2: {
                return 1.0f;
            }
            case 7: {
                return 6.0f;
            }
            case 8: {
                return 6.0f;
            }
            case 9: {
                return 6.0f;
            }
            case 10: {
                return 6.0f;
            }
            case 11: {
                return 1.0f;
            }
            case 12: {
                return 0.9f;
            }
            case 13: {
                return 1.1f;
            }
        }
        return 1.0f;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile != null && tile instanceof TileTurbineBase) {
            return ((TileTurbineBase)tile).direction.getOpposite() == side;
        }
        return false;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile != null) {
            if (tile instanceof TileTurbineBase) {
                return ((TileTurbineBase)tile).switchOrientation();
            }
            if (tile instanceof TileAirPump) {
                return ((TileAirPump)tile).rotate();
            }
            if (tile instanceof TileGeyser) {
                ((TileGeyser)tile).orientation = BlockHelper.rotate(((TileGeyser)tile).orientation);
                Packets.updateTile((TileGeyser)tile, ((TileGeyser)tile).func_70319_e());
                world.func_72902_n(x, y, z);
            }
        }
        return false;
    }

    public void func_85105_g(World world, int x, int y, int z, int side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile != null && tile instanceof TileTurbineBase) {
            TileTurbineBase turbine = (TileTurbineBase)tile;
            turbine.direction = ForgeDirection.UP;
            turbine.switchOrientation();
        }
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack stack) {
        int meta;
        TileEntity tile = world.func_72796_p(x, y, z);
        int facing = BlockPistonBase.func_72116_b((World)world, (int)x, (int)y, (int)z, (EntityLivingBase)entity);
        if (tile != null) {
            if (tile instanceof TileFLUDDStand) {
                TileFLUDDStand fludd = (TileFLUDDStand)tile;
                fludd.orientation = ForgeDirection.getOrientation((int)facing);
                int water = 0;
                if (stack.func_77942_o()) {
                    water = stack.field_77990_d.func_74762_e("water");
                }
                fludd.tank.setCapacity(20000);
                fludd.tank.setFluidID(Core.highPressureWater.getID());
                fludd.tank.setFluidAmount(water);
                Packets.updateTile(fludd, fludd.func_70319_e());
            }
            if (tile instanceof TileGeyser) {
                ((TileGeyser)tile).orientation = ForgeDirection.getOrientation((int)facing);
                Packets.updateTile((TileGeyser)tile, ((TileGeyser)tile).func_70319_e());
            }
        }
        if ((meta = stack.func_77960_j()) >= 7 && meta <= 10) {
            int l = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int i1 = world.func_72805_g(x, y, z) >> 2;
            ++l;
            if ((l %= 4) == 0) {
                world.func_72921_c(x, y, z, 9, 2);
            }
            if (l == 1) {
                world.func_72921_c(x, y, z, 10, 2);
            }
            if (l == 2) {
                world.func_72921_c(x, y, z, 7, 2);
            }
            if (l == 3) {
                world.func_72921_c(x, y, z, 8, 2);
            }
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float f, float g, float t) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile == null || player.func_70093_af() && !world.field_72995_K) {
            return false;
        }
        ItemStack held = player.func_71045_bC();
        if (held != null && held.field_77993_c == Core.crafting.field_77779_bT && held.func_77960_j() == 23) {
            return false;
        }
        if (tile instanceof TileAirPump && Extra.ACTIVATE_PUMP) {
            TileAirPump pump = (TileAirPump)tile;
            if (!pump.animate) {
                if (Modules.isActive(Modules.diving) && pump.updateAirArea(TileAirPump.Type.CHECK)) {
                    if (!world.field_72995_K) {
                        pump.supplyWithAir(300, 64.0, 64.0, 64.0);
                    }
                    pump.animate = true;
                }
                if (pump.suckUpGas(1024)) {
                    pump.animate = true;
                }
            }
            if (world.field_72995_K && player.func_70093_af()) {
                ((TileAirPump)tile).updateAirArea(TileAirPump.Type.DISPLAY);
            }
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (tile instanceof TileTurbineHand) {
            if (player.field_71092_bJ.equals("[CoFH]")) {
                return false;
            }
            if (player instanceof FakePlayer) {
                return false;
            }
            TileTurbineHand turbine = (TileTurbineHand)tile;
            turbine.energyStorage.modifyEnergyStored(((TileTurbineHand)tile).getEnergyGenerated());
            turbine.isCreatingPower = true;
            turbine.cooldown = 5;
            player.func_71024_bL().func_75122_a(0, (float)(-world.field_73013_u) * 1.5f);
            if (turbine.produced >= 1200) {
                player.func_70097_a(MaricultureDamage.turbine, (float)world.field_73013_u);
            }
            return true;
        }
        if (tile instanceof TileFLUDDStand) {
            player.openGui((Object)Mariculture.instance, 11, world, x, y, z);
            return true;
        }
        if (tile instanceof TileTurbineWater) {
            player.openGui((Object)Mariculture.instance, 10, world, x, y, z);
            return true;
        }
        if (tile instanceof TileTurbineGas) {
            player.openGui((Object)Mariculture.instance, 15, world, x, y, z);
            return true;
        }
        if (tile instanceof TileFeeder) {
            ((TileFeeder)tile).updateTankSize();
            player.openGui((Object)Mariculture.instance, 6, world, x, y, z);
            return true;
        }
        if (tile instanceof TileAnvil) {
            if (player.field_71092_bJ.equals("[CoFH]")) {
                return false;
            }
            if (player instanceof FakePlayer) {
                return false;
            }
            TileAnvil anvil = (TileAnvil)tile;
            if (anvil.func_70301_a(0) != null) {
                new Packet120ItemSync(x, y, z, anvil.getInventory()).build();
                if (!player.field_71071_by.func_70441_a(anvil.func_70301_a(0)) && !world.field_72995_K) {
                    SpawnItemHelper.spawnItem(world, x, y + 1, z, anvil.func_70301_a(0));
                }
                anvil.func_70299_a(0, null);
            } else if (player.func_71045_bC() != null) {
                ItemStack stack = player.func_71045_bC().func_77946_l();
                stack.field_77994_a = 1;
                anvil.func_70299_a(0, stack);
                player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
            }
            return true;
        }
        if (tile instanceof TileCooling) {
            if (!world.field_72995_K) {
                TileCooling caster = (TileCooling)tile;
                for (int i = 0; i < caster.func_70302_i_(); ++i) {
                    if (caster.func_70301_a(i) == null) continue;
                    SpawnItemHelper.spawnItem(world, x, y + 1, z, caster.func_70301_a(i));
                    caster.func_70299_a(i, null);
                    caster.func_70296_d();
                }
            }
            return FluidHelper.handleFillOrDrain((IFluidHandler)world.func_72796_p(x, y, z), player, ForgeDirection.UP);
        }
        if (tile instanceof TileGeyser) {
            return FluidHelper.handleFillOrDrain((IFluidHandler)world.func_72796_p(x, y, z), player, ForgeDirection.UP);
        }
        return false;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileFeeder) {
            return ((TileFeeder)tile).getLightValue();
        }
        return 0;
    }

    public void func_71921_a(World world, int x, int y, int z, EntityPlayer player) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileAnvil && ItemHelper.isPlayerHoldingItem(Core.hammer, player)) {
            if (player.field_71092_bJ.equals("[CoFH]")) {
                return;
            }
            if (player instanceof FakePlayer) {
                return;
            }
            ItemStack hammer = player.func_71045_bC();
            if (((TileAnvil)tile).workItem(player, hammer) && hammer.func_96631_a(1, Rand.rand)) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            }
        }
    }

    public void func_71902_a(IBlockAccess block, int x, int y, int z) {
        int meta = block.func_72805_g(x, y, z);
        switch (meta) {
            case 0: {
                this.func_71905_a(0.2f, 0.0f, 0.2f, 0.8f, 0.9f, 0.8f);
                break;
            }
            case 2: {
                TileGeyser geyser = (TileGeyser)block.func_72796_p(x, y, z);
                if (geyser.orientation == ForgeDirection.UP) {
                    this.func_71905_a(0.1f, 0.0f, 0.1f, 0.9f, 0.25f, 0.9f);
                }
                if (geyser.orientation == ForgeDirection.DOWN) {
                    this.func_71905_a(0.1f, 0.75f, 0.1f, 0.9f, 1.0f, 0.9f);
                }
                if (geyser.orientation == ForgeDirection.EAST) {
                    this.func_71905_a(0.0f, 0.1f, 0.1f, 0.25f, 0.9f, 0.9f);
                }
                if (geyser.orientation == ForgeDirection.WEST) {
                    this.func_71905_a(0.75f, 0.1f, 0.1f, 1.0f, 0.9f, 0.9f);
                }
                if (geyser.orientation == ForgeDirection.SOUTH) {
                    this.func_71905_a(0.1f, 0.1f, 0.0f, 0.9f, 0.9f, 0.25f);
                }
                if (geyser.orientation != ForgeDirection.NORTH) break;
                this.func_71905_a(0.1f, 0.1f, 0.75f, 0.9f, 0.9f, 1.0f);
                break;
            }
            case 7: {
                this.func_71905_a(0.125f, 0.0f, 0.0f, 0.875f, 1.0f, 1.0f);
                break;
            }
            case 8: {
                this.func_71905_a(0.0f, 0.0f, 0.125f, 1.0f, 1.0f, 0.875f);
                break;
            }
            case 9: {
                this.func_71905_a(0.125f, 0.0f, 0.0f, 0.875f, 1.0f, 1.0f);
                break;
            }
            case 10: {
                this.func_71905_a(0.0f, 0.0f, 0.125f, 1.0f, 1.0f, 0.875f);
            }
            default: {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 0.95f, 1.0f);
            }
        }
    }

    public AxisAlignedBB func_71872_e(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        if (meta == 2 || meta >= 7 && meta <= 10) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + this.field_72022_cl, (double)z + this.field_72019_cm);
        }
        return super.func_71872_e(world, x, y, z);
    }

    public TileEntity createTileEntity(World world, int meta) {
        switch (meta) {
            case 0: {
                return new TileAirPump();
            }
            case 1: {
                return new TileFeeder();
            }
            case 3: {
                return new TileTurbineWater();
            }
            case 4: {
                return new TileFLUDDStand();
            }
            case 5: {
                return new TileTurbineGas();
            }
            case 6: {
                return new TileTurbineHand();
            }
            case 2: {
                return new TileGeyser();
            }
            case 11: {
                return new TileIngotCaster();
            }
            case 13: {
                return new TileBlockCaster();
            }
            case 12: {
                return new TileNuggetCaster();
            }
        }
        if (meta >= 7 && meta <= 10) {
            return new TileAnvil();
        }
        return null;
    }

    public boolean func_71886_c() {
        return false;
    }

    public boolean func_71926_d() {
        return false;
    }

    public int func_71857_b() {
        return RenderIds.BLOCK_SINGLE;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_72796_p(x, y, z)) instanceof TileFLUDDStand && !player.field_71075_bZ.field_75098_d) {
            this.dropFLUDD(world, x, y, z);
        }
        return world.func_94571_i(x, y, z);
    }

    private void dropFLUDD(World world, int x, int y, int z) {
        TileFLUDDStand tile = (TileFLUDDStand)world.func_72796_p(x, y, z);
        ItemStack drop = new ItemStack(Factory.fludd);
        if (!drop.func_77942_o()) {
            drop.func_77982_d(new NBTTagCompound());
        }
        if (tile != null) {
            drop.field_77990_d.func_74768_a("water", tile.tank.getFluidAmount());
        }
        EntityItem entityitem = new EntityItem(world, (double)x, (double)((float)y + 1.0f), (double)z, new ItemStack(drop.field_77993_c, 1, drop.func_77960_j()));
        if (drop.func_77942_o()) {
            entityitem.func_92059_d().func_77982_d((NBTTagCompound)drop.func_77978_p().func_74737_b());
        }
        world.func_72838_d((Entity)entityitem);
    }

    public int func_71885_a(int i, Random random, int j) {
        if (i == 4) {
            return 0;
        }
        return this.field_71990_ca;
    }

    @Override
    public Icon func_71858_a(int side, int meta) {
        if (meta == 2) {
            return Block.field_94340_cs.func_71858_a(0, 0);
        }
        if (meta == 11 || meta == 13) {
            return super.func_71858_a(side, 11);
        }
        if (meta >= 7 && meta <= 10) {
            return super.func_71858_a(side, 11);
        }
        return this.icons[meta];
    }

    public int func_71899_b(int i) {
        if (i >= 7 && i <= 10) {
            return 7;
        }
        return i;
    }

    @Override
    public boolean isActive(int meta) {
        switch (meta) {
            case 1: {
                return Modules.isActive(Modules.fishery);
            }
            case 3: {
                return Modules.isActive(Modules.factory);
            }
            case 4: {
                return false;
            }
            case 5: {
                return Modules.isActive(Modules.factory);
            }
            case 2: {
                return Modules.isActive(Modules.factory);
            }
            case 6: {
                return Modules.isActive(Modules.factory);
            }
            case 8: {
                return false;
            }
            case 9: {
                return false;
            }
            case 10: {
                return false;
            }
            case 12: {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getMetaCount() {
        return 14;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = new Icon[this.getMetaCount()];
        for (int i = 0; i < this.icons.length; ++i) {
            if (i > 7 && i <= 10 || i == 13 || i == 12) continue;
            this.icons[i] = iconRegister.func_94245_a("mariculture:" + this.getName(new ItemStack(this.field_71990_ca, 1, i)));
        }
    }
}

