/*
 * Decompiled with CFR 0.152.
 */
package mariculture.core;

import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.logging.Level;
import mariculture.Mariculture;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.MaricultureTab;
import mariculture.core.Recipes;
import mariculture.core.RecipesSmelting;
import mariculture.core.RetroGen;
import mariculture.core.blocks.BlockAir;
import mariculture.core.blocks.BlockAirItem;
import mariculture.core.blocks.BlockDouble;
import mariculture.core.blocks.BlockDoubleItem;
import mariculture.core.blocks.BlockFluidMari;
import mariculture.core.blocks.BlockGlass;
import mariculture.core.blocks.BlockGlassItem;
import mariculture.core.blocks.BlockGround;
import mariculture.core.blocks.BlockGroundItem;
import mariculture.core.blocks.BlockOre;
import mariculture.core.blocks.BlockOreItem;
import mariculture.core.blocks.BlockOyster;
import mariculture.core.blocks.BlockPearlBrick;
import mariculture.core.blocks.BlockPearlBrickItem;
import mariculture.core.blocks.BlockSingle;
import mariculture.core.blocks.BlockSingleItem;
import mariculture.core.blocks.BlockTank;
import mariculture.core.blocks.BlockTankItem;
import mariculture.core.blocks.BlockTransparent;
import mariculture.core.blocks.BlockTransparentItem;
import mariculture.core.blocks.BlockUtil;
import mariculture.core.blocks.BlockUtilItem;
import mariculture.core.blocks.BlockWood;
import mariculture.core.blocks.BlockWoodItem;
import mariculture.core.blocks.TileAirPump;
import mariculture.core.blocks.TileAnvil;
import mariculture.core.blocks.TileBlockCaster;
import mariculture.core.blocks.TileBookshelf;
import mariculture.core.blocks.TileIngotCaster;
import mariculture.core.blocks.TileLiquifier;
import mariculture.core.blocks.TileNuggetCaster;
import mariculture.core.blocks.TileOyster;
import mariculture.core.blocks.TileTankBlock;
import mariculture.core.blocks.TileVat;
import mariculture.core.blocks.TileVoidBottle;
import mariculture.core.gui.GuiItemToolTip;
import mariculture.core.handlers.BiomeTypeHandler;
import mariculture.core.handlers.CastingHandler;
import mariculture.core.handlers.EnvironmentHandler;
import mariculture.core.handlers.FuelHandler;
import mariculture.core.handlers.LiquifierHandler;
import mariculture.core.handlers.LogHandler;
import mariculture.core.handlers.ModulesHandler;
import mariculture.core.handlers.OreDicHandler;
import mariculture.core.handlers.PlayerTrackerHandler;
import mariculture.core.handlers.UpgradeHandler;
import mariculture.core.handlers.VatHandler;
import mariculture.core.handlers.WorldGenHandler;
import mariculture.core.helpers.BlockTransferHelper;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.helpers.RegistryHelper;
import mariculture.core.items.ItemBattery;
import mariculture.core.items.ItemCrafting;
import mariculture.core.items.ItemFluidContainer;
import mariculture.core.items.ItemFluidStorage;
import mariculture.core.items.ItemFood;
import mariculture.core.items.ItemHammer;
import mariculture.core.items.ItemMaterial;
import mariculture.core.items.ItemPearl;
import mariculture.core.items.ItemUpgrade;
import mariculture.core.items.ItemWorked;
import mariculture.core.lib.BlockIds;
import mariculture.core.lib.ItemIds;
import mariculture.core.lib.MetalRates;
import mariculture.core.lib.Modules;
import mariculture.core.lib.RetroGeneration;
import mariculture.core.lib.WorldGeneration;
import mariculture.core.util.EntityFakeItem;
import mariculture.core.util.FluidDictionary;
import mariculture.core.util.FluidMari;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class Core
extends Modules.RegistrationModule {
    public static Block ores;
    public static Block machines;
    public static Block rendered;
    public static Block oyster;
    public static Block pearl;
    public static Block multi;
    public static Block glass;
    public static Block air;
    public static Block wood;
    public static Block tanks;
    public static Block dirt;
    public static Block transparent;
    public static Fluid moltenAluminum;
    public static Fluid moltenTitanium;
    public static Fluid moltenIron;
    public static Fluid moltenGold;
    public static Fluid moltenCopper;
    public static Fluid moltenTin;
    public static Fluid moltenMagnesium;
    public static Fluid moltenBronze;
    public static Fluid moltenLead;
    public static Fluid moltenSilver;
    public static Fluid moltenSteel;
    public static Fluid moltenNickel;
    public static Fluid moltenRutile;
    public static Fluid moltenGlass;
    public static Fluid moltenSalt;
    public static Fluid moltenElectrum;
    public static Fluid naturalGas;
    public static Fluid quicklime;
    public static Fluid highPressureWater;
    public static Block highPressureWaterBlock;
    public static Item bottles;
    public static Item materials;
    public static Item crafting;
    public static Item batteryTitanium;
    public static Item batteryCopper;
    public static Item food;
    public static Item upgrade;
    public static Item pearls;
    public static Item hammer;
    public static Item worked;
    public static Item ladle;
    public static Item bucket;
    EnumToolMaterial brick = EnumHelper.addToolMaterial((String)"BRICK", (int)1, (int)1000, (float)3.0f, (float)1.2f, (int)12);
    @Deprecated
    public static Block oreBlocks;

    @Override
    public void registerHandlers() {
        OreDicHandler.registerWildCards();
        MaricultureHandlers.biomeType = new BiomeTypeHandler();
        MaricultureHandlers.smelter = new LiquifierHandler();
        MaricultureHandlers.casting = new CastingHandler();
        MaricultureHandlers.vat = new VatHandler();
        MaricultureHandlers.anvil = new TileAnvil();
        MaricultureHandlers.upgrades = new UpgradeHandler();
        MaricultureHandlers.modules = new ModulesHandler();
        MaricultureHandlers.environment = new EnvironmentHandler();
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        GameRegistry.registerWorldGenerator((IWorldGenerator)new WorldGenHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GuiItemToolTip());
        MinecraftForge.EVENT_BUS.register((Object)new OreDicHandler());
        GameRegistry.registerPlayerTracker((IPlayerTracker)new PlayerTrackerHandler());
        if (RetroGeneration.ENABLED) {
            MinecraftForge.EVENT_BUS.register((Object)new RetroGen());
        }
        ArrayList<Integer> sides = new ArrayList<Integer>();
        for (int i = 0; i < 6; ++i) {
            sides.add(i);
        }
        BlockTransferHelper.sides = sides;
    }

    @Override
    public void registerBlocks() {
        ores = new BlockOre(BlockIds.ores).func_71884_a(Block.field_71976_h).func_71894_b(5.0f).func_71864_b("oreBlocks");
        machines = new BlockUtil(BlockIds.util).func_71884_a(Block.field_71976_h).func_71848_c(2.0f).func_71894_b(5.0f).func_71864_b("utilBlocks");
        multi = new BlockDouble(BlockIds.doubleBlocks).func_71884_a(Block.field_71977_i).func_71894_b(3.0f).func_71864_b("doubleBlocks").func_71848_c(3.0f);
        rendered = new BlockSingle(BlockIds.singleBlocks).func_71884_a(Block.field_71976_h).func_71848_c(1.0f).func_71894_b(1.0f).func_71864_b("customBlocks");
        oyster = new BlockOyster(BlockIds.oyster).func_71884_a(Block.field_71976_h).func_71848_c(10.0f).func_71894_b(50.0f).func_71864_b("oysterBlock").func_71900_a(0.4f);
        pearl = new BlockPearlBrick(BlockIds.pearlBlock, "pearlBlock_").func_71864_b("pearlBlock");
        glass = new BlockGlass(BlockIds.glassBlocks).func_71884_a(Block.field_71974_j).func_71894_b(10.0f).func_71864_b("glassBlocks");
        air = new BlockAir(BlockIds.airBlocks).func_71864_b("airBlocks");
        wood = new BlockWood(BlockIds.woodBlocks).func_71864_b("woodBlocks").func_71848_c(2.0f);
        tanks = new BlockTank(BlockIds.tankBlocks).func_71864_b("tankBlocks").func_71848_c(1.0f);
        dirt = new BlockGround(BlockIds.groundBlocks).func_71864_b("groundBlocks").func_71848_c(1.0f);
        transparent = new BlockTransparent(BlockIds.transparentBlocks).func_71884_a(Block.field_71974_j).func_71864_b("transparentBlocks").func_71848_c(1.0f);
        Item.field_77698_e[BlockIds.ores] = new BlockOreItem(BlockIds.ores - 256, ores).func_77655_b("oreBlocks");
        Item.field_77698_e[BlockIds.util] = new BlockUtilItem(BlockIds.util - 256, machines).func_77655_b("utilBlocks");
        Item.field_77698_e[BlockIds.singleBlocks] = new BlockSingleItem(BlockIds.singleBlocks - 256, rendered).func_77655_b("customBlocks");
        Item.field_77698_e[BlockIds.doubleBlocks] = new BlockDoubleItem(BlockIds.doubleBlocks - 256, multi).func_77655_b("doubleBlocks");
        Item.field_77698_e[BlockIds.pearlBlock] = new BlockPearlBrickItem(BlockIds.pearlBlock - 256, pearl).func_77655_b("pearlBlock");
        Item.field_77698_e[BlockIds.glassBlocks] = new BlockGlassItem(BlockIds.glassBlocks - 256, glass).func_77655_b("glassBlocks");
        Item.field_77698_e[BlockIds.airBlocks] = new BlockAirItem(BlockIds.airBlocks - 256, air).func_77655_b("airBlocks");
        Item.field_77698_e[BlockIds.woodBlocks] = new BlockWoodItem(BlockIds.woodBlocks - 256, wood).func_77655_b("woodBlocks");
        Item.field_77698_e[BlockIds.tankBlocks] = new BlockTankItem(BlockIds.tankBlocks - 256, tanks).func_77655_b("tankBlocks");
        Item.field_77698_e[BlockIds.groundBlocks] = new BlockGroundItem(BlockIds.groundBlocks - 256, dirt).func_77655_b("groundBlocks");
        Item.field_77698_e[BlockIds.transparentBlocks] = new BlockTransparentItem(BlockIds.transparentBlocks - 256, transparent).func_77655_b("transparentBlocks");
        GameRegistry.registerBlock((Block)oyster, (String)"Mariculture_oysterBlock");
        GameRegistry.registerTileEntity(TileAirPump.class, (String)"tileEntityAirPump");
        GameRegistry.registerTileEntity(TileOyster.class, (String)"tileEntityOyster");
        GameRegistry.registerTileEntity(TileLiquifier.class, (String)"tileEntityLiquifier");
        GameRegistry.registerTileEntity(TileBookshelf.class, (String)"tileBookshelf");
        GameRegistry.registerTileEntity(TileTankBlock.class, (String)"tileTankBlock");
        GameRegistry.registerTileEntity(TileVat.class, (String)"tileVatBlock");
        GameRegistry.registerTileEntity(TileAnvil.class, (String)"tileBlacksmithAnvil");
        GameRegistry.registerTileEntity(TileIngotCaster.class, (String)"tileIngotCaster");
        GameRegistry.registerTileEntity(TileVoidBottle.class, (String)"tileVoidBottle");
        GameRegistry.registerTileEntity(TileNuggetCaster.class, (String)"tileNuggetCaster");
        GameRegistry.registerTileEntity(TileBlockCaster.class, (String)"tileBlockCaster");
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)8, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)1, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)12, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)3, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)4, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)6, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)5, (String)"pickaxe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)10, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)2, (String)"pickaxe", (int)2);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)9, (String)"pickaxe", (int)2);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)13, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)ores, (int)14, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)machines, (int)3, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)rendered, (int)7, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)rendered, (int)8, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)rendered, (int)9, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)rendered, (int)10, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)rendered, (int)0, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)rendered, (int)11, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)multi, (int)3, (String)"pickaxe", (int)1);
        MinecraftForge.setBlockHarvestLevel((Block)machines, (int)6, (String)"axe", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)dirt, (int)0, (String)"shovel", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)wood, (int)0, (String)"axe", (int)1);
        RegistryHelper.register(new Object[]{ores, pearl, oyster, machines, multi, rendered, glass, air, wood, tanks, dirt, transparent});
    }

    @Override
    public void registerItems() {
        materials = new ItemMaterial(ItemIds.metals).func_77655_b("materials");
        crafting = new ItemCrafting(ItemIds.items).func_77655_b("craftingItems");
        batteryCopper = new ItemBattery(ItemIds.batteryCopper, 10000, 100, 250).func_77655_b("batteryCopper");
        batteryTitanium = new ItemBattery(ItemIds.batteryTitanium, 100000, 1000, 2500).func_77655_b("batteryTitanium");
        food = new ItemFood(ItemIds.food).func_77655_b("food");
        upgrade = new ItemUpgrade(ItemIds.upgrade).func_77655_b("upgrade");
        pearls = new ItemPearl(ItemIds.pearl).func_77655_b("pearls");
        bottles = new ItemFluidContainer(ItemIds.liquidContainers).func_77655_b("liquidContainers");
        hammer = new ItemHammer(ItemIds.hammer, this.brick).func_77655_b("hammer");
        worked = new ItemWorked(ItemIds.worked).func_77655_b("worked");
        ladle = new ItemFluidStorage(ItemIds.ladle, MetalRates.INGOT).func_77655_b("ladle");
        bucket = new ItemFluidStorage(ItemIds.bucket, 8000).func_77655_b("titaniumBucket");
        MinecraftForge.setToolClass((Item)hammer, (String)"pickaxe", (int)0);
        RegistryHelper.register(new Object[]{materials, crafting, batteryTitanium, food, upgrade, pearls, bottles, hammer, worked, batteryCopper, ladle, bucket});
    }

    @Override
    public void registerOther() {
        this.registerBiomes();
        this.registerEntities();
        this.registerLiquids();
        this.addToOreDictionary();
        if (!Modules.isActive(Modules.worldplus) && WorldGeneration.DEEP_OCEAN) {
            this.addDeepOcean();
        }
        MaricultureTab.tabMariculture.icon = new ItemStack(pearls, 1, 0);
    }

    private void registerEntities() {
        EntityRegistry.registerModEntity(EntityFakeItem.class, (String)"FakeItem", (int)44, (Object)Mariculture.instance, (int)80, (int)3, (boolean)false);
    }

    private void addDeepOcean() {
        try {
            Field field = BiomeGenBase.class.getField("ocean");
            if (field == null) {
                field = BiomeGenBase.class.getField("field_76771_b");
            }
            BiomeGenBase newValue = new BiomeGenOcean(0).func_76739_b(112).func_76735_a("Ocean").func_76725_b(-1.8f, 0.4f);
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(null, newValue);
        }
        catch (Exception e) {
            LogHandler.log(Level.INFO, "Mariculture failed to adjust the ocean depth");
        }
    }

    private void registerLiquids() {
        highPressureWater = new FluidMari(FluidDictionary.hp_water, -1);
        if (!FluidRegistry.registerFluid((Fluid)highPressureWater)) {
            highPressureWater = FluidRegistry.getFluid((String)FluidDictionary.hp_water);
        }
        highPressureWaterBlock = new BlockFluidMari(BlockIds.highPressureWater, highPressureWater, Material.field_76244_g).func_71864_b("highPressureWater");
        GameRegistry.registerBlock((Block)highPressureWaterBlock, (String)"Mariculture_highPressureWaterBlock");
        if (highPressureWater.getBlockID() == -1) {
            highPressureWater.setBlockID(highPressureWaterBlock);
        }
        Core.registerHeatBottle(FluidDictionary.hp_water, 1000, 26);
    }

    private void addToOreDictionary() {
        OreDicHelper.add("glass", new ItemStack(Block.field_71946_M));
        OreDicHelper.add("ingotIron", new ItemStack(Item.field_77703_o));
        OreDicHelper.add("ingotGold", new ItemStack(Item.field_77717_p));
        OreDicHelper.add("blockIron", new ItemStack(Block.field_72083_ai));
        OreDicHelper.add("blockGold", new ItemStack(Block.field_72105_ah));
        OreDicHelper.add("blockLapis", new ItemStack(Block.field_71948_O));
        OreDicHelper.add("blockCoal", new ItemStack(Block.field_111034_cE));
        OreDicHelper.add("blockRedstone", new ItemStack(Block.field_94341_cq));
        OreDicHelper.add("dustRedstone", new ItemStack(Item.field_77767_aC));
        OreDictionary.registerOre((String)"blockLimestone", (ItemStack)new ItemStack(ores, 1, 3));
        OreDictionary.registerOre((String)"limestone", (ItemStack)new ItemStack(ores, 1, 3));
        OreDictionary.registerOre((String)"oreCopper", (ItemStack)new ItemStack(ores, 1, 1));
        OreDictionary.registerOre((String)"oreAluminum", (ItemStack)new ItemStack(ores, 1, 0));
        OreDictionary.registerOre((String)"oreAluminium", (ItemStack)new ItemStack(ores, 1, 0));
        OreDictionary.registerOre((String)"oreNaturalAluminum", (ItemStack)new ItemStack(ores, 1, 0));
        OreDictionary.registerOre((String)"oreRutile", (ItemStack)new ItemStack(ores, 1, 2));
        OreDictionary.registerOre((String)"blockAluminum", (ItemStack)new ItemStack(ores, 1, 8));
        OreDictionary.registerOre((String)"blockAluminium", (ItemStack)new ItemStack(ores, 1, 8));
        OreDictionary.registerOre((String)"blockNaturalAluminum", (ItemStack)new ItemStack(ores, 1, 8));
        OreDictionary.registerOre((String)"blockCopper", (ItemStack)new ItemStack(ores, 1, 12));
        OreDictionary.registerOre((String)"blockMagnesium", (ItemStack)new ItemStack(ores, 1, 10));
        OreDictionary.registerOre((String)"blockTitanium", (ItemStack)new ItemStack(ores, 1, 9));
        OreDictionary.registerOre((String)"blockRutile", (ItemStack)new ItemStack(ores, 1, 11));
        OreDictionary.registerOre((String)"foodSalt", (ItemStack)new ItemStack(materials, 1, 12));
        OreDictionary.registerOre((String)"dustSalt", (ItemStack)new ItemStack(materials, 1, 12));
        OreDictionary.registerOre((String)"ingotAluminum", (ItemStack)new ItemStack(materials, 1, 0));
        OreDictionary.registerOre((String)"ingotAluminium", (ItemStack)new ItemStack(materials, 1, 0));
        OreDictionary.registerOre((String)"ingotNaturalAluminum", (ItemStack)new ItemStack(materials, 1, 0));
        OreDictionary.registerOre((String)"ingotCopper", (ItemStack)new ItemStack(materials, 1, 4));
        OreDictionary.registerOre((String)"ingotMagnesium", (ItemStack)new ItemStack(materials, 1, 1));
        OreDictionary.registerOre((String)"ingotRutile", (ItemStack)new ItemStack(materials, 1, 3));
        OreDictionary.registerOre((String)"ingotTitanium", (ItemStack)new ItemStack(materials, 1, 2));
        OreDictionary.registerOre((String)"nuggetIron", (ItemStack)new ItemStack(materials, 1, 33));
        OreDictionary.registerOre((String)"nuggetAluminum", (ItemStack)new ItemStack(materials, 1, 34));
        OreDictionary.registerOre((String)"nuggetAluminium", (ItemStack)new ItemStack(materials, 1, 34));
        OreDictionary.registerOre((String)"nuggetNaturalAluminum", (ItemStack)new ItemStack(materials, 1, 34));
        OreDictionary.registerOre((String)"nuggetCopper", (ItemStack)new ItemStack(materials, 1, 38));
        OreDictionary.registerOre((String)"nuggetMagnesium", (ItemStack)new ItemStack(materials, 1, 35));
        OreDictionary.registerOre((String)"nuggetRutile", (ItemStack)new ItemStack(materials, 1, 37));
        OreDictionary.registerOre((String)"nuggetTitanium", (ItemStack)new ItemStack(materials, 1, 36));
        OreDictionary.registerOre((String)"dyeYellow", (ItemStack)new ItemStack(materials, 1, 30));
        OreDictionary.registerOre((String)"dyeRed", (ItemStack)new ItemStack(materials, 1, 31));
        OreDictionary.registerOre((String)"dyeBrown", (ItemStack)new ItemStack(materials, 1, 32));
        OreDictionary.registerOre((String)"dyeGreen", (ItemStack)new ItemStack(materials, 1, 29));
        OreDictionary.registerOre((String)"dyeWhite", (ItemStack)new ItemStack(materials, 1, 27));
        OreDictionary.registerOre((String)"dyeBlue", (ItemStack)new ItemStack(materials, 1, 28));
    }

    private void addFluids() {
        FluidDictionary.natural_gas = Core.addFluid("gas.natural", naturalGas, 2000, 2);
        FluidDictionary.quicklime = Core.addFluid("quicklime", quicklime, 1000, 18);
        FluidDictionary.salt = Core.addFluid("salt.molten", moltenSalt, 1000, 19);
        FluidDictionary.glass = Core.addFluid("glass.molten", moltenGlass, 1000, 15);
        FluidDictionary.aluminum = Core.addFluid("aluminum.molten", moltenAluminum, MetalRates.ORE, 11);
        FluidDictionary.magnesium = Core.addFluid("magnesium.molten", moltenMagnesium, MetalRates.ORE, 13);
        FluidDictionary.titanium = Core.addFluid("titanium.molten", moltenTitanium, MetalRates.ORE, 12);
        FluidDictionary.copper = Core.addFluid("copper.molten", moltenCopper, MetalRates.ORE, 5);
        FluidDictionary.rutile = Core.addFluid("rutile.molten", moltenRutile, MetalRates.ORE, 17);
        FluidDictionary.iron = Core.addFluid("iron.molten", moltenIron, MetalRates.ORE, 3);
        FluidDictionary.gold = Core.addFluid("gold.molten", moltenGold, MetalRates.ORE, 4);
        FluidDictionary.tin = Core.addFluid("tin.molten", moltenTin, MetalRates.ORE, 6);
        FluidDictionary.lead = Core.addFluid("lead.molten", moltenLead, MetalRates.ORE, 8);
        FluidDictionary.silver = Core.addFluid("silver.molten", moltenSilver, MetalRates.ORE, 7);
        FluidDictionary.nickel = Core.addFluid("nickel.molten", moltenNickel, MetalRates.ORE, 14);
        FluidDictionary.bronze = Core.addFluid("bronze.molten", moltenBronze, MetalRates.ORE, 9);
        FluidDictionary.steel = Core.addFluid("steel.molten", moltenSteel, MetalRates.ORE, 10);
        FluidDictionary.electrum = Core.addFluid("electrum.molten", moltenElectrum, MetalRates.ORE, 21);
        Core.registerVanillaBottle(FluidDictionary.natural_gas, 1000, 27);
        Core.registerHeatBottle("water", 2000, 22);
        Core.registerHeatBottle("lava", 2000, 23);
    }

    public static void registerHeatBottle(String fluid, int vol, int meta) {
        FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)fluid, (int)vol), (ItemStack)new ItemStack(bottles, 1, meta), (ItemStack)new ItemStack(bottles, 1, 20));
    }

    public static void registerVanillaBottle(String fluid, int vol, int meta) {
        FluidContainerRegistry.registerFluidContainer((FluidStack)FluidRegistry.getFluidStack((String)fluid, (int)vol), (ItemStack)new ItemStack(bottles, 1, meta), (ItemStack)new ItemStack(Item.field_77729_bt));
    }

    public static String addFluid(String name, Fluid globalFluid, int volume, int bottleMeta) {
        if (!FluidDictionary.instance.fluidExists(name)) {
            globalFluid = new FluidMari(name, bottleMeta).setUnlocalizedName(name);
            FluidRegistry.registerFluid((Fluid)globalFluid);
            FluidDictionary.instance.addFluid(name, globalFluid);
        }
        Fluid fluid = FluidDictionary.getFluid(name);
        if (volume != -1) {
            Core.registerHeatBottle(fluid.getName(), volume, bottleMeta);
        }
        return FluidDictionary.getFluid(name).getName();
    }

    private void registerBiomes() {
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76787_r, Environment.Salinity.BRACKISH, 25);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76769_d, Environment.Salinity.FRESH, 45);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76786_s, Environment.Salinity.FRESH, 45);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76770_e, Environment.Salinity.FRESH, 5);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76783_v, Environment.Salinity.FRESH, 7);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76767_f, Environment.Salinity.FRESH, 10);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76785_t, Environment.Salinity.FRESH, 8);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76776_l, Environment.Salinity.SALINE, -1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76777_m, Environment.Salinity.FRESH, -1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76778_j, Environment.Salinity.FRESH, 80);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76775_o, Environment.Salinity.FRESH, -1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76774_n, Environment.Salinity.FRESH, -1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76782_w, Environment.Salinity.FRESH, 25);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76792_x, Environment.Salinity.FRESH, 24);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76789_p, Environment.Salinity.FRESH, 15);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76788_q, Environment.Salinity.BRACKISH, 20);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76771_b, Environment.Salinity.SALINE, 4);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76772_c, Environment.Salinity.FRESH, 10);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76781_i, Environment.Salinity.FRESH, 10);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76779_k, Environment.Salinity.FRESH, 3);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76780_h, Environment.Salinity.FRESH, 8);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76768_g, Environment.Salinity.FRESH, 1);
        MaricultureHandlers.environment.addEnvironment(BiomeGenBase.field_76784_u, Environment.Salinity.FRESH, 0);
    }

    @Override
    public void registerRecipes() {
        this.addFluids();
        Recipes.add();
    }

    @Override
    public void postInit() {
        RecipesSmelting.postAdd();
        super.postInit();
        oreBlocks = ores;
    }
}

