/*
 * Decompiled with CFR 0.152.
 */
package mariculture.api.fishery.fish;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import mariculture.api.core.Environment;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.fishery.CachedCoords;
import mariculture.api.fishery.EnumRodQuality;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.RodQuality;
import mariculture.api.fishery.fish.EnumFishGroup;
import mariculture.api.fishery.fish.FishProduct;
import mariculture.core.handlers.LogHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class FishSpecies {
    private static HashMap<String, Integer> ids = new HashMap();
    public static HashMap<Integer, FishSpecies> species = new HashMap();
    private static final HashMap<String, ArrayList<FishProduct>> products = new HashMap();
    public int[] temperature;
    public Environment.Salinity[] salinity;
    private Icon theIcon;
    private Icon altIcon;
    @Deprecated
    public int fishID;
    @Deprecated
    public static ArrayList speciesList = null;

    public FishSpecies(int id) {
        if (!species.containsKey(id)) {
            this.fishID = id;
            ids.put(this.getSpecies(), id);
            species.put(id, this);
        } else {
            LogHandler.log(Level.INFO, "A Mod Attempted to register a Mariculture Fish with the ID of " + id + " but it was already taken");
        }
    }

    public final int getID() {
        return ids.get(this.getSpecies());
    }

    public String getSpecies() {
        return this.getClass().getSimpleName().toLowerCase().substring(4);
    }

    protected final boolean isAcceptedTemperature(int temp) {
        return temp >= this.temperature[0] && temp <= this.temperature[1];
    }

    public abstract int[] setSuitableTemperature();

    public abstract Environment.Salinity[] setSuitableSalinity();

    public boolean isLavaFish() {
        return false;
    }

    public abstract boolean isDominant();

    public abstract int getLifeSpan();

    public abstract int getFertility();

    public int getBaseProductivity() {
        return 1;
    }

    public int getFoodConsumption() {
        return 1;
    }

    public boolean requiresFood() {
        return true;
    }

    public int getWaterRequired() {
        return 15;
    }

    public int getAreaOfEffectBonus(ForgeDirection dir) {
        return 0;
    }

    public final ArrayList<FishProduct> getProductList() {
        return products.get(this.getSpecies());
    }

    public abstract void addFishProducts();

    public final void addProduct(Block block, double chance) {
        this.addProduct(new ItemStack(block), chance);
    }

    public final void addProduct(Item item, double chance) {
        this.addProduct(new ItemStack(item), chance);
    }

    public final void addProduct(ItemStack stack, double chance) {
        String fish = this.getSpecies();
        ArrayList<Object> list = null;
        list = products.containsKey(fish) ? products.get(fish) : new ArrayList();
        if (list.size() < 6) {
            list.add(new FishProduct(stack, chance));
        }
        products.put(fish, list);
    }

    public final ItemStack getProduct(Random rand) {
        for (FishProduct product : products.get(this.getSpecies())) {
            int chance = (int)(product.chance * 10.0);
            if (rand.nextInt(1000) >= chance) continue;
            return product.product.func_77946_l();
        }
        return null;
    }

    public double getFishOilVolume() {
        return 0.166;
    }

    public ItemStack getLiquifiedProduct() {
        return new ItemStack(Item.field_77755_aX);
    }

    public int getLiquifiedProductChance() {
        return 10;
    }

    public int getFishMealSize() {
        return (int)Math.max(Math.floor(this.getFishOilVolume()), 1.0);
    }

    public int getFoodStat() {
        return (int)Math.ceil(this.getFishOilVolume());
    }

    public float getFoodSaturation() {
        return (float)(this.getFishOilVolume() / 10.0);
    }

    public int getFoodDuration() {
        return 32;
    }

    public boolean canAlwaysEat() {
        return false;
    }

    public void onConsumed(World world, EntityPlayer player) {
    }

    public ItemStack onRightClick(World world, EntityPlayer player, ItemStack stack, Random rand) {
        return stack;
    }

    public void affectWorld(World world, int x, int y, int z, ArrayList<CachedCoords> coords) {
    }

    public void affectLiving(EntityLivingBase entity) {
    }

    public int getLightValue() {
        return 0;
    }

    public boolean canWork(int time) {
        return true;
    }

    public abstract RodQuality getRodNeeded();

    public boolean isWorldCorrect(World world) {
        return !world.field_73011_w.field_76575_d && world.field_73011_w.field_76574_g != 1;
    }

    public double getCatchChance(World world, Environment.Salinity salt, int temp, int time, int height) {
        return this.isWorldCorrect(world) && MaricultureHandlers.environment.matches(salt, temp, this.salinity, this.temperature) ? this.getCatchChance(world, height, time) : 0.0;
    }

    public double getCatchChance(World world, int height, int time) {
        return this.isWorldCorrect(world) ? this.getCatchChance(height, time) : 0.0;
    }

    public double getCatchChance(int height, int time) {
        return this.getCatchChance();
    }

    public int getCatchChance() {
        return 5;
    }

    public double getCaughtAliveChance(World world, Environment.Salinity salt, int temp, int time, int height) {
        return this.isAcceptedTemperature(temp) && salt == this.salinity[0] ? this.getCaughtAliveChance(world, height, time) : 0.0;
    }

    public double getCaughtAliveChance(World world, int height, int time) {
        return this.getCaughtAliveChance(height, time);
    }

    public double getCaughtAliveChance(int height, int time) {
        return this.getCaughtAliveChance();
    }

    public double getCaughtAliveChance() {
        return 0.0;
    }

    public String getName() {
        return StatCollector.func_74838_a((String)("fish.data.species." + this.getSpecies()));
    }

    public boolean hasGenderIcons() {
        return false;
    }

    public Icon getIcon(int gender) {
        return this.hasGenderIcons() && gender == 0 ? this.altIcon : this.theIcon;
    }

    public void registerIcon(IconRegister iconRegister) {
        if (this.hasGenderIcons()) {
            this.theIcon = iconRegister.func_94245_a("mariculture:fish/" + this.getSpecies() + "_female");
            this.altIcon = iconRegister.func_94245_a("mariculture:fish/" + this.getSpecies() + "_male");
        } else {
            this.theIcon = iconRegister.func_94245_a("mariculture:fish/" + this.getSpecies());
        }
    }

    @Deprecated
    public EnumFishGroup getGroup() {
        return EnumFishGroup.OCEAN;
    }

    @Deprecated
    public Icon getIcon() {
        return this.getIcon(0);
    }

    @Deprecated
    public boolean caughtAsRaw() {
        return true;
    }

    @Deprecated
    public boolean canCatch(Random rand, World world, int x, int y, int z, EnumRodQuality quality) {
        return false;
    }

    @Deprecated
    public boolean canLive(World world, int x, int y, int z) {
        return Fishing.fishHelper.canLive(world, x, y, z, Fishing.fishHelper.makePureFish(this));
    }

    @Deprecated
    public int[] getChestGenChance() {
        return new int[]{1, 3, 5};
    }

    @Deprecated
    public int getSurvivability() {
        return 0;
    }

    @Deprecated
    public void affectWorld(World world, int x, int y, int z, int tankType) {
    }

    @Deprecated
    public int getTankLevel() {
        return 1;
    }
}

