/*
 * Decompiled with CFR 0.152.
 */
package mariculture.api.fishery.fish;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import mariculture.api.fishery.fish.FishDNABase;
import mariculture.core.lib.Text;
import mariculture.fishery.FishHelper;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;

public class FishDNA
extends FishDNABase {
    public ArrayList<FishDNA> types;
    private boolean isHidden = false;
    private boolean isToggled = false;
    public String name;
    public int minimum;
    public int maximum;
    public boolean isDominant;

    @Override
    public FishDNA register() {
        this.types = new ArrayList();
        DNAParts.add(this);
        return this;
    }

    public void add(String name, int min, int max, boolean dominant) {
        this.types.add(new FishDNA().setValues(name, min, max, dominant));
    }

    public FishDNA setHidden() {
        this.isHidden = true;
        return this;
    }

    public FishDNA setShift() {
        this.isToggled = true;
        return this;
    }

    public FishDNA setValues(String name, int min, int max, boolean dominant) {
        this.name = name;
        this.minimum = min;
        this.maximum = max;
        this.isDominant = dominant;
        return this;
    }

    @Override
    public void getInformationDisplay(ItemStack stack, List list) {
        if (this.isHidden) {
            return;
        }
        if (!this.isToggled || this.isToggled && Keyboard.isKeyDown((int)42)) {
            int type = stack.func_77978_p().func_74762_e(this.getHigherString());
            for (FishDNA dna : this.types) {
                if (type < dna.minimum || type > dna.maximum) continue;
                String data = Keyboard.isKeyDown((int)42) ? "" + this.getDNA(stack) : Text.localize("fish.data." + this.getHigherString().toLowerCase() + "." + dna.name);
                list.add(Text.localize("fish.data." + this.getHigherString().toLowerCase()) + ": " + data);
            }
        }
    }

    public String getDNAName(ItemStack stack) {
        int type = stack.func_77978_p().func_74762_e(this.getHigherString());
        for (FishDNA dna : this.types) {
            if (type < dna.minimum || type > dna.maximum) continue;
            return Text.localize("fish.data." + this.getHigherString().toLowerCase() + "." + dna.name);
        }
        return "";
    }

    public String getLowerDNAName(ItemStack stack) {
        int type = stack.func_77978_p().func_74762_e(this.getLowerString());
        for (FishDNA dna : this.types) {
            if (type < dna.minimum || type > dna.maximum) continue;
            return Text.localize("fish.data." + this.getHigherString().toLowerCase() + "." + dna.name);
        }
        return "";
    }

    @Override
    public int[] getDominant(int option1, int option2, Random rand) {
        int dominance1 = 0;
        int dominance2 = 0;
        for (FishDNA dna : this.types) {
            if (option1 >= dna.minimum && option1 <= dna.maximum) {
                int n = dominance1 = dna.isDominant ? 0 : 1;
            }
            if (option2 < dna.minimum || option2 > dna.maximum) continue;
            dominance2 = dna.isDominant ? 0 : 1;
        }
        return FishHelper.swapDominance(dominance1, dominance2, option1, option2, rand);
    }

    @Override
    public String[] getScannedDisplay(ItemStack stack) {
        boolean is1Dominant = false;
        boolean is2Dominant = false;
        int option1 = this.getDNA(stack);
        int option2 = this.getLowerDNA(stack);
        for (FishDNA dna : this.types) {
            if (option1 >= dna.minimum && option1 <= dna.maximum) {
                is1Dominant = dna.isDominant;
            }
            if (option2 < dna.minimum || option2 > dna.maximum) continue;
            is2Dominant = dna.isDominant;
        }
        String display1 = (is1Dominant ? "\u00a76" : "\u00a79") + this.getDNA(stack) + " (" + this.getDNAName(stack) + ")";
        String display2 = (is2Dominant ? "\u00a76" : "\u00a79") + this.getLowerDNA(stack) + " (" + this.getLowerDNAName(stack) + ")";
        return new String[]{Text.localize("fish.data." + this.getName().toLowerCase()), display1, display2};
    }
}

