/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.mariculture.action;

import mariculture.api.fishery.Loot;
import modtweaker.mariculture.MaricultureHacks;
import modtweaker.util.ItemHelper;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.value.TweakerItemStack;

public class FishingRemoveLootAction
implements IUndoableAction {
    private final TweakerItemStack output;
    private boolean bad;
    private Loot loot;

    public FishingRemoveLootAction(TweakerItemStack output) {
        this.output = output;
    }

    public void apply() {
        int i;
        int removed = -1;
        for (i = 0; i < MaricultureHacks.badLoot.size(); ++i) {
            if (MaricultureHacks.badLoot.get(i) == null || !ItemHelper.areEqual(this.output.get(), MaricultureHacks.badLoot.get((int)i).loot)) continue;
            this.bad = true;
            this.loot = MaricultureHacks.badLoot.get(i);
            removed = i;
            break;
        }
        if (removed < 0) {
            for (i = 0; i < MaricultureHacks.goodLoot.size(); ++i) {
                if (MaricultureHacks.goodLoot.get(i) == null || !ItemHelper.areEqual(this.output.get(), MaricultureHacks.goodLoot.get((int)i).loot)) continue;
                this.bad = false;
                this.loot = MaricultureHacks.goodLoot.get(i);
                removed = i;
                break;
            }
            MaricultureHacks.goodLoot.remove(removed);
        } else {
            MaricultureHacks.badLoot.remove(removed);
        }
    }

    public boolean canUndo() {
        if (this.bad) {
            return MaricultureHacks.badLoot != null;
        }
        return MaricultureHacks.goodLoot != null;
    }

    public void undo() {
        if (this.bad) {
            MaricultureHacks.badLoot.add(this.loot);
        } else {
            MaricultureHacks.goodLoot.add(this.loot);
        }
    }

    public String describe() {
        return "Removing Fishing Loot: " + this.output.getDisplayName();
    }

    public String describeUndo() {
        return "Restoring Fishing Loot: " + this.output.getDisplayName();
    }
}

