/*
 * Decompiled with CFR 0.152.
 */
package modtweaker.bloodmagic;

import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipe;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipeRegistry;
import modtweaker.util.TweakerBaseFunction;
import modtweaker.util.TweakerHelper;
import net.minecraft.item.ItemStack;
import stanhebben.minetweaker.api.IUndoableAction;
import stanhebben.minetweaker.api.Tweaker;
import stanhebben.minetweaker.api.value.TweakerValue;

public class AlchemyAddRecipe
extends TweakerBaseFunction {
    public static final AlchemyAddRecipe INSTANCE = new AlchemyAddRecipe();

    private AlchemyAddRecipe() {
        super("bloodmagic.alchemy.addRecipe");
    }

    @Override
    public void perform(TweakerValue ... args) {
        if (TweakerHelper.canContinue(4, args)) {
            ItemStack output = TweakerHelper.getItem();
            ItemStack[] input = TweakerHelper.getItems();
            int tier = TweakerHelper.getInt();
            int lp = TweakerHelper.getInt();
            Tweaker.apply((IUndoableAction)new Action(new AlchemyRecipe(output, lp, input, tier)));
        } else {
            TweakerHelper.throwException((TweakerBaseFunction)this, 4);
        }
    }

    private static class Action
    implements IUndoableAction {
        private final AlchemyRecipe recipe;

        public Action(AlchemyRecipe recipe) {
            this.recipe = recipe;
        }

        public void apply() {
            AlchemyRecipeRegistry.recipes.add(this.recipe);
        }

        public boolean canUndo() {
            return AlchemyRecipeRegistry.recipes != null;
        }

        public void undo() {
            AlchemyRecipeRegistry.recipes.remove(this.recipe);
        }

        public String describe() {
            return "Adding Alchemy Recipe: " + this.recipe.getResult().func_82833_r();
        }

        public String describeUndo() {
            return "Removing Alchemy Recipe: " + this.recipe.getResult().func_82833_r();
        }
    }
}

